@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEips.
 * @property addressName
 * @property addresses
 * @property associatedInstanceId
 * @property associatedInstanceType
 * @property dryRun
 * @property eips A list of EIPs. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of EIP IDs.
 * @property includeReservationData
 * @property ipAddress Public IP Address of the the EIP.
 * @property ipAddresses
 * @property isp
 * @property lockReason
 * @property nameRegex
 * @property names (Optional) A list of EIP names.
 * @property outputFile
 * @property paymentType
 * @property resourceGroupId The Id of resource group which the eips belongs.
 * @property segmentInstanceId
 * @property status EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
 * @property tags
 */
public data class GetEipsResult(
    public val addressName: String? = null,
    public val addresses: List<GetEipsAddress>,
    public val associatedInstanceId: String? = null,
    public val associatedInstanceType: String? = null,
    public val dryRun: Boolean? = null,
    @Deprecated(
        message = """
  Field 'eips' has been deprecated from provider version 1.126.0 and it will be removed in the
      future version. Please use the new attribute 'addresses' instead.
  """,
    )
    public val eips: List<GetEipsEip>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: Boolean? = null,
    public val ipAddress: String? = null,
    @Deprecated(
        message = """
  Field 'ip_addresses' has been deprecated from provider version 1.126.0 and it will be removed in
      the future version. Please use the new attribute 'ip_address' instead.
  """,
    )
    public val ipAddresses: List<String>? = null,
    public val isp: String? = null,
    public val lockReason: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val segmentInstanceId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEipsResult): GetEipsResult =
            GetEipsResult(
                addressName = javaType.addressName().map({ args0 -> args0 }).orElse(null),
                addresses = javaType.addresses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetEipsAddress.Companion.toKotlin(args0)
                    })
                }),
                associatedInstanceId = javaType.associatedInstanceId().map({ args0 -> args0 }).orElse(null),
                associatedInstanceType = javaType.associatedInstanceType().map({ args0 -> args0 }).orElse(null),
                dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
                eips = javaType.eips().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetEipsEip.Companion.toKotlin(args0)
                    })
                }),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
                ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
                ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
                isp = javaType.isp().map({ args0 -> args0 }).orElse(null),
                lockReason = javaType.lockReason().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
                resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
                segmentInstanceId = javaType.segmentInstanceId().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
