@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property allocatedResources Details of resource allocation.
 * @property description Description of flexible guarantee service.
 * @property elasticityAssuranceId The first ID of the resource
 * @property endTime Flexible guarantee service failure time.
 * @property id ID of flexible guarantee service.
 * @property instanceChargeType The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
 * @property privatePoolOptionsId The ID of the elasticity assurance.
 * @property privatePoolOptionsMatchCriteria The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
 * @property privatePoolOptionsName The name of the elasticity assurance.
 * @property resourceGroupId The ID of the resource group.
 * @property startTime Flexible guarantee service effective time.
 * @property startTimeType Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
 * @property status The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
 * @property tags The tag key-value pair information bound by the elastic guarantee service.
 * @property totalAssuranceTimes The total number of flexible guarantee services.
 * @property usedAssuranceTimes This parameter is not yet available.
 */
public data class GetElasticityAssurancesAssurance(
    public val allocatedResources: List<GetElasticityAssurancesAssuranceAllocatedResource>,
    public val description: String,
    public val elasticityAssuranceId: String,
    public val endTime: String,
    public val id: String,
    public val instanceChargeType: String,
    public val privatePoolOptionsId: String,
    public val privatePoolOptionsMatchCriteria: String,
    public val privatePoolOptionsName: String,
    public val resourceGroupId: String,
    public val startTime: String,
    public val startTimeType: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val totalAssuranceTimes: String,
    public val usedAssuranceTimes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetElasticityAssurancesAssurance): GetElasticityAssurancesAssurance = GetElasticityAssurancesAssurance(
            allocatedResources = javaType.allocatedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetElasticityAssurancesAssuranceAllocatedResource.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            elasticityAssuranceId = javaType.elasticityAssuranceId(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType(),
            privatePoolOptionsId = javaType.privatePoolOptionsId(),
            privatePoolOptionsMatchCriteria = javaType.privatePoolOptionsMatchCriteria(),
            privatePoolOptionsName = javaType.privatePoolOptionsName(),
            resourceGroupId = javaType.resourceGroupId(),
            startTime = javaType.startTime(),
            startTimeType = javaType.startTimeType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalAssuranceTimes = javaType.totalAssuranceTimes(),
            usedAssuranceTimes = javaType.usedAssuranceTimes(),
        )
    }
}
