@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType Instance type.
 * @property totalAmount The total number of instances that need to be reserved within an instance type.
 * @property usedAmount The number of instances that have been used.
 * @property zoneId The zone ID.
 */
public data class GetElasticityAssurancesAssuranceAllocatedResource(
    public val instanceType: String,
    public val totalAmount: Int,
    public val usedAmount: Int,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetElasticityAssurancesAssuranceAllocatedResource): GetElasticityAssurancesAssuranceAllocatedResource =
            GetElasticityAssurancesAssuranceAllocatedResource(
                instanceType = javaType.instanceType(),
                totalAmount = javaType.totalAmount(),
                usedAmount = javaType.usedAmount(),
                zoneId = javaType.zoneId(),
            )
    }
}
