@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getElasticityAssurances.
 * @property assurances A list of Elasticity Assurance Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Elasticity Assurance IDs.
 * @property outputFile
 * @property privatePoolOptionsIds
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
 * @property tags A mapping of tags to assign to the Capacity Reservation.
 */
public data class GetElasticityAssurancesResult(
    public val assurances: List<GetElasticityAssurancesAssurance>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val privatePoolOptionsIds: List<String>? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetElasticityAssurancesResult): GetElasticityAssurancesResult = GetElasticityAssurancesResult(
            assurances = javaType.assurances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetElasticityAssurancesAssurance.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            privatePoolOptionsIds = javaType.privatePoolOptionsIds().map({ args0 -> args0 }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
