@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property architecture The image architecture. Valid values: `i386` and `x86_64`.
 * @property creationTime Time of creation.
 * @property description Description of the image.
 * @property diskDeviceMappings Description of the system with disks and snapshots under the image.
 * @property id ID of the image.
 * @property imageId The ID of the image.
 * @property imageOwnerAlias Alias of the image owner.
 * @property imageVersion Version of the image.
 * @property isCopied
 * @property isSelfShared
 * @property isSubscribed Whether the user has subscribed to the terms of service for the image product corresponding to the ProductCode.
 * @property isSupportIoOptimized Specifies whether the image can be used on I/O optimized instances.
 * @property name
 * @property osName Display Chinese name of the OS.
 * @property osNameEn Display English name of the OS.
 * @property osType The operating system type of the image. Valid values: `windows` and `linux`.
 * @property platform
 * @property productCode Product code of the image on the image market.
 * @property progress Progress of image creation, presented in percentages.
 * @property size Size of the created disk.
 * @property state
 * @property status The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
 * * `Creating`: The image is being created.
 * * `Waiting`: The image is waiting to be processed.
 * * `Available`: The image is available.
 * * `UnAvailable`: The image is unavailable.
 * * `CreateFailed`: The image failed to be created.
 * * `Deprecated`: The image is discontinued.
 * @property tags A mapping of tags to assign to the resource.
 * @property usage Specifies whether to check the validity of the request without actually making the request. Valid values:
 */
public data class GetImagesImage(
    public val architecture: String,
    public val creationTime: String,
    public val description: String,
    public val diskDeviceMappings: List<GetImagesImageDiskDeviceMapping>,
    public val id: String,
    public val imageId: String,
    public val imageOwnerAlias: String,
    public val imageVersion: String,
    public val isCopied: Boolean,
    public val isSelfShared: String,
    public val isSubscribed: Boolean,
    public val isSupportIoOptimized: Boolean,
    public val name: String,
    public val osName: String,
    public val osNameEn: String,
    public val osType: String,
    public val platform: String,
    public val productCode: String,
    public val progress: String,
    public val size: Int,
    public val state: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val usage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetImagesImage): GetImagesImage =
            GetImagesImage(
                architecture = javaType.architecture(),
                creationTime = javaType.creationTime(),
                description = javaType.description(),
                diskDeviceMappings = javaType.diskDeviceMappings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetImagesImageDiskDeviceMapping.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                imageId = javaType.imageId(),
                imageOwnerAlias = javaType.imageOwnerAlias(),
                imageVersion = javaType.imageVersion(),
                isCopied = javaType.isCopied(),
                isSelfShared = javaType.isSelfShared(),
                isSubscribed = javaType.isSubscribed(),
                isSupportIoOptimized = javaType.isSupportIoOptimized(),
                name = javaType.name(),
                osName = javaType.osName(),
                osNameEn = javaType.osNameEn(),
                osType = javaType.osType(),
                platform = javaType.platform(),
                productCode = javaType.productCode(),
                progress = javaType.progress(),
                size = javaType.size(),
                state = javaType.state(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                usage = javaType.usage(),
            )
    }
}
