@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property device Device information of the created disk: such as /dev/xvdb.
 * @property size Size of the created disk.
 * @property snapshotId The ID of the snapshot used to create the custom image.
 */
public data class GetImagesImageDiskDeviceMapping(
    public val device: String,
    public val size: String,
    public val snapshotId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetImagesImageDiskDeviceMapping): GetImagesImageDiskDeviceMapping = GetImagesImageDiskDeviceMapping(
            device = javaType.device(),
            size = javaType.size(),
            snapshotId = javaType.snapshotId(),
        )
    }
}
