@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getImages.
 * @property actionType
 * @property architecture Platform type of the image system: i386 or x86_64.
 * @property dryRun
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of image IDs.
 * @property imageFamily
 * @property imageId
 * @property imageName
 * @property imageOwnerId
 * @property images A list of images. Each element contains the following attributes:
 * @property instanceType
 * @property isSupportCloudInit
 * @property isSupportIoOptimized
 * @property mostRecent
 * @property nameRegex
 * @property osType
 * @property outputFile
 * @property owners
 * @property resourceGroupId
 * @property snapshotId Snapshot ID.
 * @property status Status of the image. Possible values: `UnAvailable`, `Available`, `Creating` and `CreateFailed`.
 * @property tags
 * @property usage
 */
public data class GetImagesResult(
    public val actionType: String? = null,
    public val architecture: String? = null,
    public val dryRun: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val imageFamily: String? = null,
    public val imageId: String? = null,
    public val imageName: String? = null,
    public val imageOwnerId: String? = null,
    public val images: List<GetImagesImage>,
    public val instanceType: String? = null,
    public val isSupportCloudInit: Boolean? = null,
    public val isSupportIoOptimized: Boolean? = null,
    public val mostRecent: Boolean? = null,
    public val nameRegex: String? = null,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val owners: String? = null,
    public val resourceGroupId: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val usage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetImagesResult): GetImagesResult = GetImagesResult(
            actionType = javaType.actionType().map({ args0 -> args0 }).orElse(null),
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            imageFamily = javaType.imageFamily().map({ args0 -> args0 }).orElse(null),
            imageId = javaType.imageId().map({ args0 -> args0 }).orElse(null),
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            imageOwnerId = javaType.imageOwnerId().map({ args0 -> args0 }).orElse(null),
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetImagesImage.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            isSupportCloudInit = javaType.isSupportCloudInit().map({ args0 -> args0 }).orElse(null),
            isSupportIoOptimized = javaType.isSupportIoOptimized().map({ args0 -> args0 }).orElse(null),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            owners = javaType.owners().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            usage = javaType.usage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
