@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceKeywords.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of keywords.
 * @property key
 * @property keywords An array that consists of reserved keywords.
 * @property outputFile
 */
public data class GetInstanceKeywordsResult(
    public val id: String,
    public val ids: List<String>,
    public val key: String,
    public val keywords: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstanceKeywordsResult): GetInstanceKeywordsResult = GetInstanceKeywordsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            key = javaType.key(),
            keywords = javaType.keywords().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
