@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property generation The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
 * @property id ID of the instance type family.
 * @property zoneIds A list of Zone to launch the instance.
 */
public data class GetInstanceTypeFamiliesFamily(
    public val generation: String,
    public val id: String,
    public val zoneIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstanceTypeFamiliesFamily): GetInstanceTypeFamiliesFamily = GetInstanceTypeFamiliesFamily(
            generation = javaType.generation(),
            id = javaType.id(),
            zoneIds = javaType.zoneIds().map({ args0 -> args0 }),
        )
    }
}
