@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypeFamilies.
 * @property families
 * @property generation The generation of the instance type family.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of instance type family IDs.
 * @property instanceChargeType
 * @property outputFile
 * @property spotStrategy
 * @property zoneId
 */
public data class GetInstanceTypeFamiliesResult(
    public val families: List<GetInstanceTypeFamiliesFamily>,
    public val generation: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String? = null,
    public val outputFile: String? = null,
    public val spotStrategy: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstanceTypeFamiliesResult): GetInstanceTypeFamiliesResult = GetInstanceTypeFamiliesResult(
            families = javaType.families().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypeFamiliesFamily.Companion.toKotlin(args0)
                })
            }),
            generation = javaType.generation().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            spotStrategy = javaType.spotStrategy().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
