@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones List of availability zones that support the instance type.
 * @property burstableInstance The burstable instance attribution:
 * - initial_credit: The initial CPU credit of a burstable instance.
 * - baseline_credit:  The compute performance benchmark CPU credit of a burstable instance.
 * @property cpuCoreCount Filter the results to a specific number of cpu cores.
 * @property eniAmount Filter the result whose network interface number is no more than `eni_amount`.
 * @property family The instance type family.
 * @property gpu The GPU attribution of an instance type:
 * - amount: The amount of GPU of an instance type.
 * - category: The category of GPU of an instance type.
 * @property id ID of the instance type.
 * @property localStorage Local storage of an instance type:
 * - capacity: The capacity of a local storage in GB.
 * - amount:  The number of local storage devices that an instance has been attached to.
 * - category: The category of local storage that an instance has been attached to.
 * @property memorySize Filter the results to a specific memory size in GB.
 * @property nvmeSupport Indicates whether the cloud disk can be attached by using the nonvolatile memory express (NVMe) protocol. Valid values:
 * - required: The cloud disk can be attached by using the NVMe protocol.
 * - unsupported: The cloud disk cannot be attached by using the NVMe protocol.
 * @property price The price of instance type.
 */
public data class GetInstanceTypesInstanceType(
    public val availabilityZones: List<String>,
    public val burstableInstance: GetInstanceTypesInstanceTypeBurstableInstance,
    public val cpuCoreCount: Int,
    public val eniAmount: Int,
    public val family: String,
    public val gpu: GetInstanceTypesInstanceTypeGpu,
    public val id: String,
    public val localStorage: GetInstanceTypesInstanceTypeLocalStorage,
    public val memorySize: Double,
    public val nvmeSupport: String,
    public val price: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstanceTypesInstanceType): GetInstanceTypesInstanceType = GetInstanceTypesInstanceType(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            burstableInstance = javaType.burstableInstance().let({ args0 ->
                com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesInstanceTypeBurstableInstance.Companion.toKotlin(args0)
            }),
            cpuCoreCount = javaType.cpuCoreCount(),
            eniAmount = javaType.eniAmount(),
            family = javaType.family(),
            gpu = javaType.gpu().let({ args0 ->
                com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesInstanceTypeGpu.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            localStorage = javaType.localStorage().let({ args0 ->
                com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesInstanceTypeLocalStorage.Companion.toKotlin(args0)
            }),
            memorySize = javaType.memorySize(),
            nvmeSupport = javaType.nvmeSupport(),
            price = javaType.price(),
        )
    }
}
