@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypes.
 * @property availabilityZone
 * @property cpuCoreCount Number of CPU cores.
 * @property eniAmount The maximum number of network interfaces that an instance type can be attached to.
 * @property gpuAmount
 * @property gpuSpec
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of instance type IDs.
 * @property imageId
 * @property instanceChargeType
 * @property instanceType
 * @property instanceTypeFamily
 * @property instanceTypes A list of image types. Each element contains the following attributes:
 * @property isOutdated
 * @property kubernetesNodeRole
 * @property memorySize Size of memory, measured in GB.
 * @property minimumEniIpv6AddressQuantity
 * @property minimumEniPrivateIpAddressQuantity
 * @property networkType
 * @property outputFile
 * @property sortedBy
 * @property spotStrategy
 * @property systemDiskCategory
 */
public data class GetInstanceTypesResult(
    public val availabilityZone: String? = null,
    public val cpuCoreCount: Int? = null,
    public val eniAmount: Int? = null,
    public val gpuAmount: Int? = null,
    public val gpuSpec: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val imageId: String? = null,
    public val instanceChargeType: String? = null,
    public val instanceType: String? = null,
    public val instanceTypeFamily: String? = null,
    public val instanceTypes: List<GetInstanceTypesInstanceType>,
    public val isOutdated: Boolean? = null,
    public val kubernetesNodeRole: String? = null,
    public val memorySize: Double? = null,
    public val minimumEniIpv6AddressQuantity: Int? = null,
    public val minimumEniPrivateIpAddressQuantity: Int? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val sortedBy: String? = null,
    public val spotStrategy: String? = null,
    public val systemDiskCategory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstanceTypesResult): GetInstanceTypesResult = GetInstanceTypesResult(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            cpuCoreCount = javaType.cpuCoreCount().map({ args0 -> args0 }).orElse(null),
            eniAmount = javaType.eniAmount().map({ args0 -> args0 }).orElse(null),
            gpuAmount = javaType.gpuAmount().map({ args0 -> args0 }).orElse(null),
            gpuSpec = javaType.gpuSpec().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            imageId = javaType.imageId().map({ args0 -> args0 }).orElse(null),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            instanceTypeFamily = javaType.instanceTypeFamily().map({ args0 -> args0 }).orElse(null),
            instanceTypes = javaType.instanceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesInstanceType.Companion.toKotlin(args0)
                })
            }),
            isOutdated = javaType.isOutdated().map({ args0 -> args0 }).orElse(null),
            kubernetesNodeRole = javaType.kubernetesNodeRole().map({ args0 -> args0 }).orElse(null),
            memorySize = javaType.memorySize().map({ args0 -> args0 }).orElse(null),
            minimumEniIpv6AddressQuantity = javaType.minimumEniIpv6AddressQuantity().map({ args0 ->
                args0
            }).orElse(null),
            minimumEniPrivateIpAddressQuantity = javaType.minimumEniPrivateIpAddressQuantity().map({ args0 ->
                args0
            }).orElse(null),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sortedBy = javaType.sortedBy().map({ args0 -> args0 }).orElse(null),
            spotStrategy = javaType.spotStrategy().map({ args0 -> args0 }).orElse(null),
            systemDiskCategory = javaType.systemDiskCategory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
