@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property availabilityZone Availability zone where instances are located.
 * @property creationTime Instance creation time.
 * @property description Instance description.
 * @property diskDeviceMappings Description of the attached disks.
 * @property eip EIP address the VPC instance is using.
 * @property id ID of the instance.
 * @property imageId The image ID of some ECS instance used.
 * @property instanceChargeType Instance charge type.
 * @property instanceType Instance type.
 * @property internetChargeType Instance network charge type.
 * @property internetMaxBandwidthOut Max output bandwidth for internet.
 * @property keyName Key pair the instance is using.
 * @property name Instance name.
 * @property privateIp Instance private IP address.
 * @property publicIp Instance public IP address.
 * @property ramRoleName The RAM role name which the instance attaches.
 * @property regionId Region ID the instance belongs to.
 * @property resourceGroupId The ID of resource group which the instance belongs.
 * @property securityGroups List of security group IDs the instance belongs to.
 * @property spotStrategy Spot strategy the instance is using.
 * @property status Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
 * @property tags A map of tags assigned to the ECS instances. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const taggedInstances = alicloud.ecs.getInstances({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * tagged_instances = alicloud.ecs.get_instances(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taggedInstances = AliCloud.Ecs.GetInstances.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var taggedInstances = EcsFunctions.getInstances(GetInstancesArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   taggedInstances:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstances
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property vpcId ID of the VPC linked to the instances.
 * @property vswitchId ID of the vSwitch linked to the instances.
 */
public data class GetInstancesInstance(
    public val availabilityZone: String,
    public val creationTime: String,
    public val description: String,
    public val diskDeviceMappings: List<GetInstancesInstanceDiskDeviceMapping>,
    public val eip: String,
    public val id: String,
    public val imageId: String,
    public val instanceChargeType: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val internetMaxBandwidthOut: Int,
    public val keyName: String,
    public val name: String,
    public val privateIp: String,
    public val publicIp: String,
    public val ramRoleName: String,
    public val regionId: String,
    public val resourceGroupId: String,
    public val securityGroups: List<String>,
    public val spotStrategy: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            availabilityZone = javaType.availabilityZone(),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            diskDeviceMappings = javaType.diskDeviceMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetInstancesInstanceDiskDeviceMapping.Companion.toKotlin(args0)
                })
            }),
            eip = javaType.eip(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceChargeType = javaType.instanceChargeType(),
            instanceType = javaType.instanceType(),
            internetChargeType = javaType.internetChargeType(),
            internetMaxBandwidthOut = javaType.internetMaxBandwidthOut(),
            keyName = javaType.keyName(),
            name = javaType.name(),
            privateIp = javaType.privateIp(),
            publicIp = javaType.publicIp(),
            ramRoleName = javaType.ramRoleName(),
            regionId = javaType.regionId(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            spotStrategy = javaType.spotStrategy(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
