@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category Cloud disk category.
 * @property device Device information of the created disk: such as /dev/xvdb.
 * @property diskId The ID of the Disk.
 * @property diskName The name of the Disk.
 * @property size Size of the created disk.
 * @property type Cloud disk type: system disk or data disk.
 */
public data class GetInstancesInstanceDiskDeviceMapping(
    public val category: String,
    public val device: String,
    public val diskId: String,
    public val diskName: String,
    public val size: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetInstancesInstanceDiskDeviceMapping): GetInstancesInstanceDiskDeviceMapping = GetInstancesInstanceDiskDeviceMapping(
            category = javaType.category(),
            device = javaType.device(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            size = javaType.size(),
            type = javaType.type(),
        )
    }
}
