@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The ID of the availability zone where the ECS instance is located.
 * @property description
 * @property imageId
 * @property instanceId The ID of the ECS instance.
 * @property instanceName The name of the ECS instance.
 * @property instanceType
 * @property keyName Name of the key pair.
 * @property privateIp The private IP address of the ECS instance.
 * @property publicIp The public IP address or EIP of the ECS instance.
 * @property regionId
 * @property status
 * @property vswitchId The ID of the vSwitch attached to the ECS instance.
 */
public data class GetKeyPairsKeyPairInstance(
    public val availabilityZone: String,
    public val description: String,
    public val imageId: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceType: String,
    public val keyName: String,
    public val privateIp: String,
    public val publicIp: String,
    public val regionId: String,
    public val status: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetKeyPairsKeyPairInstance): GetKeyPairsKeyPairInstance = GetKeyPairsKeyPairInstance(
            availabilityZone = javaType.availabilityZone(),
            description = javaType.description(),
            imageId = javaType.imageId(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            keyName = javaType.keyName(),
            privateIp = javaType.privateIp(),
            publicIp = javaType.publicIp(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
