@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property fingerPrint A finger print used to retrieve specified key pair.
 * @property id ID of the key pair.
 * @property instances A list of ECS instances that has been bound this key pair.
 * @property keyName Name of the key pair.
 * @property keyPairName
 * @property resourceGroupId The Id of resource group which the key pair belongs.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetKeyPairsPair(
    public val fingerPrint: String,
    public val id: String,
    public val instances: List<GetKeyPairsPairInstance>,
    public val keyName: String,
    public val keyPairName: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetKeyPairsPair): GetKeyPairsPair = GetKeyPairsPair(
            fingerPrint = javaType.fingerPrint(),
            id = javaType.id(),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetKeyPairsPairInstance.Companion.toKotlin(args0)
                })
            }),
            keyName = javaType.keyName(),
            keyPairName = javaType.keyPairName(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
