@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property associatedPublicIps
 * @property creationTime Creation time of the ENI.
 * @property description Description of the ENI.
 * @property id ID of the ENI.
 * @property instanceId ID of the instance that the ENI is attached to.
 * @property ipv6Sets
 * @property mac MAC address of the ENI.
 * @property name Name of the ENI.
 * @property networkInterfaceId
 * @property networkInterfaceName
 * @property networkInterfaceTrafficMode
 * @property ownerId
 * @property primaryIpAddress
 * @property privateIp Primary private IP of the ENI.
 * @property privateIpAddresses
 * @property privateIps A list of secondary private IP address that is assigned to the ENI.
 * @property queueNumber
 * @property resourceGroupId The Id of resource group.
 * @property securityGroupIds
 * @property securityGroups A list of security group that the ENI belongs to.
 * @property serviceId
 * @property serviceManaged
 * @property status Current status of the ENI.
 * @property tags A map of tags assigned to the ENI.
 * @property type
 * @property vpcId ID of the VPC that the ENI belongs to.
 * @property vswitchId ID of the vSwitch that the ENI is linked to.
 * @property zoneId ID of the availability zone that the ENI belongs to.
 */
public data class GetNetworkInterfacesInterface(
    public val associatedPublicIps: List<GetNetworkInterfacesInterfaceAssociatedPublicIp>,
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val ipv6Sets: List<String>,
    public val mac: String,
    public val name: String,
    public val networkInterfaceId: String,
    public val networkInterfaceName: String,
    public val networkInterfaceTrafficMode: String,
    public val ownerId: String,
    public val primaryIpAddress: String,
    public val privateIp: String,
    public val privateIpAddresses: List<String>,
    public val privateIps: List<String>,
    public val queueNumber: Int,
    public val resourceGroupId: String,
    public val securityGroupIds: List<String>,
    public val securityGroups: List<String>,
    public val serviceId: Int,
    public val serviceManaged: Boolean,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetNetworkInterfacesInterface): GetNetworkInterfacesInterface = GetNetworkInterfacesInterface(
            associatedPublicIps = javaType.associatedPublicIps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetNetworkInterfacesInterfaceAssociatedPublicIp.Companion.toKotlin(args0)
                })
            }),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ipv6Sets = javaType.ipv6Sets().map({ args0 -> args0 }),
            mac = javaType.mac(),
            name = javaType.name(),
            networkInterfaceId = javaType.networkInterfaceId(),
            networkInterfaceName = javaType.networkInterfaceName(),
            networkInterfaceTrafficMode = javaType.networkInterfaceTrafficMode(),
            ownerId = javaType.ownerId(),
            primaryIpAddress = javaType.primaryIpAddress(),
            privateIp = javaType.privateIp(),
            privateIpAddresses = javaType.privateIpAddresses().map({ args0 -> args0 }),
            privateIps = javaType.privateIps().map({ args0 -> args0 }),
            queueNumber = javaType.queueNumber(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            serviceId = javaType.serviceId(),
            serviceManaged = javaType.serviceManaged(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
