@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecurityGroupRules.
 * @property direction Authorization direction, `ingress` or `egress`.
 * @property groupDesc The description of the security group that owns the rules.
 * @property groupId
 * @property groupName The name of the security group that owns the rules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipProtocol The protocol. Can be `tcp`, `udp`, `icmp`, `gre` or `all`.
 * @property nicType Network type, `internet` or `intranet`.
 * @property outputFile
 * @property policy Authorization policy. Can be either `accept` or `drop`.
 * @property rules A list of security group rules. Each element contains the following attributes:
 */
public data class GetSecurityGroupRulesResult(
    public val direction: String? = null,
    public val groupDesc: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val ipProtocol: String? = null,
    public val nicType: String? = null,
    public val outputFile: String? = null,
    public val policy: String? = null,
    public val rules: List<GetSecurityGroupRulesRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetSecurityGroupRulesResult): GetSecurityGroupRulesResult = GetSecurityGroupRulesResult(
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            groupDesc = javaType.groupDesc(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            ipProtocol = javaType.ipProtocol().map({ args0 -> args0 }).orElse(null),
            nicType = javaType.nicType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetSecurityGroupRulesRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
