@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the rule.
 * @property destCidrIp Target IP address segment for egress authorization.
 * @property destGroupId Target security group id for ingress authorization.
 * @property destGroupOwnerAccount Alibaba Cloud account of the target security group.
 * @property direction Authorization direction. Valid values are: `ingress` or `egress`.
 * @property ipProtocol The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
 * @property nicType Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
 * @property policy Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
 * @property portRange The range of port numbers.
 * @property priority Rule priority.
 * @property sourceCidrIp Source IP address segment for ingress authorization.
 * @property sourceGroupId Source security group ID for ingress authorization.
 * @property sourceGroupOwnerAccount Alibaba Cloud account of the source security group.
 */
public data class GetSecurityGroupRulesRule(
    public val description: String,
    public val destCidrIp: String,
    public val destGroupId: String,
    public val destGroupOwnerAccount: String,
    public val direction: String,
    public val ipProtocol: String,
    public val nicType: String,
    public val policy: String,
    public val portRange: String,
    public val priority: Int,
    public val sourceCidrIp: String,
    public val sourceGroupId: String,
    public val sourceGroupOwnerAccount: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetSecurityGroupRulesRule): GetSecurityGroupRulesRule = GetSecurityGroupRulesRule(
            description = javaType.description(),
            destCidrIp = javaType.destCidrIp(),
            destGroupId = javaType.destGroupId(),
            destGroupOwnerAccount = javaType.destGroupOwnerAccount(),
            direction = javaType.direction(),
            ipProtocol = javaType.ipProtocol(),
            nicType = javaType.nicType(),
            policy = javaType.policy(),
            portRange = javaType.portRange(),
            priority = javaType.priority(),
            sourceCidrIp = javaType.sourceCidrIp(),
            sourceGroupId = javaType.sourceGroupId(),
            sourceGroupOwnerAccount = javaType.sourceGroupOwnerAccount(),
        )
    }
}
