@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property creationTime Creation time of the security group.
 * @property description The description of the security group.
 * @property id The ID of the security group.
 * @property innerAccess Whether to allow inner network access.
 * @property name The name of the security group.
 * @property resourceGroupId The Id of resource group which the security_group belongs.
 * @property securityGroupType The type of the security group.
 * @property tags A map of tags assigned to the ECS instances. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const taggedSecurityGroups = alicloud.ecs.getSecurityGroups({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * tagged_security_groups = alicloud.ecs.get_security_groups(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taggedSecurityGroups = AliCloud.Ecs.GetSecurityGroups.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.GetSecurityGroups(ctx, &ecs.GetSecurityGroupsArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var taggedSecurityGroups = EcsFunctions.getSecurityGroups(GetSecurityGroupsArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   taggedSecurityGroups:
 *     fn::invoke:
 *       Function: alicloud:ecs:getSecurityGroups
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property vpcId Used to retrieve security groups that belong to the specified VPC ID.
 */
public data class GetSecurityGroupsGroup(
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val innerAccess: Boolean,
    public val name: String,
    public val resourceGroupId: String,
    public val securityGroupType: String,
    public val tags: Map<String, String>? = null,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetSecurityGroupsGroup): GetSecurityGroupsGroup = GetSecurityGroupsGroup(
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            id = javaType.id(),
            innerAccess = javaType.innerAccess(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupType = javaType.securityGroupType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
