@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property category
 * @property creationTime Creation time. Time of creation. It is represented according to ISO8601, and UTC time is used. Format: YYYY-MM-DDThh:mmZ.
 * @property description Description of the snapshot.
 * @property diskId
 * @property encrypted Whether the snapshot is encrypted or not.
 * @property id ID of the snapshot.
 * @property instantAccess
 * @property instantAccessRetentionDays
 * @property name Name of the snapshot.
 * @property productCode Product code on the image market place.
 * @property progress Progress of snapshot creation, presented in percentage.
 * @property remainTime The remaining time of a snapshot creation task, in seconds.
 * @property resourceGroupId
 * @property retentionDays The number of days that an automatic snapshot retains in the console for your instance.
 * @property snapshotId
 * @property snapshotName
 * @property snapshotSn
 * @property snapshotType
 * @property sourceDiskId Source disk ID, which is retained after the source disk of the snapshot is deleted.
 * @property sourceDiskSize Size of the source disk, measured in GB.
 * @property sourceDiskType Source disk attribute. Value range: `System`,`Data`.
 * @property sourceStorageType
 * @property status The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
 * @property tags A map of tags assigned to the snapshot.
 * @property type
 * @property usage Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
 */
public data class GetSnapshotsSnapshot(
    public val category: String,
    public val creationTime: String,
    public val description: String,
    public val diskId: String,
    public val encrypted: Boolean,
    public val id: String,
    public val instantAccess: Boolean,
    public val instantAccessRetentionDays: Int,
    public val name: String,
    public val productCode: String,
    public val progress: String,
    public val remainTime: Int,
    public val resourceGroupId: String,
    public val retentionDays: Int,
    public val snapshotId: String,
    public val snapshotName: String,
    public val snapshotSn: String,
    public val snapshotType: String,
    public val sourceDiskId: String,
    public val sourceDiskSize: String,
    public val sourceDiskType: String,
    public val sourceStorageType: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val usage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetSnapshotsSnapshot): GetSnapshotsSnapshot = GetSnapshotsSnapshot(
            category = javaType.category(),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            diskId = javaType.diskId(),
            encrypted = javaType.encrypted(),
            id = javaType.id(),
            instantAccess = javaType.instantAccess(),
            instantAccessRetentionDays = javaType.instantAccessRetentionDays(),
            name = javaType.name(),
            productCode = javaType.productCode(),
            progress = javaType.progress(),
            remainTime = javaType.remainTime(),
            resourceGroupId = javaType.resourceGroupId(),
            retentionDays = javaType.retentionDays(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            snapshotSn = javaType.snapshotSn(),
            snapshotType = javaType.snapshotType(),
            sourceDiskId = javaType.sourceDiskId(),
            sourceDiskSize = javaType.sourceDiskSize(),
            sourceDiskType = javaType.sourceDiskType(),
            sourceStorageType = javaType.sourceStorageType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            usage = javaType.usage(),
        )
    }
}
