@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property device The device name of disk N in the custom image. Valid values:
 * - For disks other than basic disks, such as standard SSDs, ultra disks, and enhanced SSDs (ESSDs), the valid values range from /dev/vda to /dev/vdz in alphabetical order.
 * - For basic disks, the valid values range from /dev/xvda to /dev/xvdz in alphabetical order.
 * @property diskType The type of disk N in the custom image. You can specify this parameter to create the system disk of the custom image from a data disk snapshot. If you do not specify this parameter, the disk type is determined by the corresponding snapshot. Valid values:
 * - system: system disk. You can specify only one snapshot to use to create the system disk in the custom image.
 * - data: data disk. You can specify up to 16 snapshots to use to create data disks in the custom image.
 * @property format Image format.
 * @property importOssBucket Import the bucket of the OSS to which the image belongs.
 * @property importOssObject Import the object of the OSS to which the image file belongs.
 * @property progress Copy the progress of the task.
 * @property remainTime For an image being replicated, return the remaining time of the replication task, in seconds.
 * @property size The size of disk N in the custom image. Unit: GiB. The valid values and default value of DiskDeviceMapping.N.Size vary based on the value of DiskDeviceMapping.N.SnapshotId.
 * - If no corresponding snapshot IDs are specified in the value of DiskDeviceMapping.N.SnapshotId, DiskDeviceMapping.N.Size has the following valid values and default values:
 * *   For basic disks, the valid values range from 5 to 2000, and the default value is 5.
 * *   For other disks, the valid values range from 20 to 32768, and the default value is 20.
 * - If a corresponding snapshot ID is specified in the value of DiskDeviceMapping.N.SnapshotId, the value of DiskDeviceMapping.N.Size must be greater than or equal to the size of the specified snapshot. The default value of DiskDeviceMapping.N.Size is the size of the specified snapshot.
 * @property snapshotId The ID of snapshot N to use to create the custom image. .
 */
public data class ImageDiskDeviceMapping(
    public val device: String? = null,
    public val diskType: String? = null,
    public val format: String? = null,
    public val importOssBucket: String? = null,
    public val importOssObject: String? = null,
    public val progress: String? = null,
    public val remainTime: Int? = null,
    public val size: Int? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.ImageDiskDeviceMapping): ImageDiskDeviceMapping = ImageDiskDeviceMapping(
            device = javaType.device().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            importOssBucket = javaType.importOssBucket().map({ args0 -> args0 }).orElse(null),
            importOssObject = javaType.importOssObject().map({ args0 -> args0 }).orElse(null),
            progress = javaType.progress().map({ args0 -> args0 }).orElse(null),
            remainTime = javaType.remainTime().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
