@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property nvmeSupport Specifies whether to support the Non-Volatile Memory Express (NVMe) protocol. Valid values:
 * - supported: The image supports NVMe. Instances created from this image also support NVMe.
 * - unsupported: The image does not support NVMe. Instances created from this image do not support NVMe.
 */
public data class ImageFeatures(
    public val nvmeSupport: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.ImageFeatures): ImageFeatures =
            ImageFeatures(
                nvmeSupport = javaType.nvmeSupport().map({ args0 -> args0 }).orElse(null),
            )
    }
}
