@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property device The device name of the disk.
 * @property diskImageSize The size of the disk. Default value: `5`.
 * @property format The format of the image. Valid values: `RAW`, `VHD`, `qcow2`.
 * @property ossBucket The OSS bucket where the image file is stored.
 * @property ossObject The name (key) of the object that the uploaded image is stored as in the OSS bucket.
 */
public data class ImageImportDiskDeviceMapping(
    public val device: String? = null,
    public val diskImageSize: Int? = null,
    public val format: String? = null,
    public val ossBucket: String? = null,
    public val ossObject: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.ImageImportDiskDeviceMapping): ImageImportDiskDeviceMapping = ImageImportDiskDeviceMapping(
            device = javaType.device().map({ args0 -> args0 }).orElse(null),
            diskImageSize = javaType.diskImageSize().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            ossBucket = javaType.ossBucket().map({ args0 -> args0 }).orElse(null),
            ossObject = javaType.ossObject().map({ args0 -> args0 }).orElse(null),
        )
    }
}
