@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property category The category of the disk:
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
 * @property description The description of the data disk.
 * @property device The mount point of the data disk.
 * @property encrypted Encrypted the data in this disk. Default value: `false`.
 * @property kmsKeyId The KMS key ID corresponding to the Nth data disk.
 * @property name The name of the data disk.
 * @property performanceLevel The performance level of the ESSD used as data disk:
 * - `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
 * - `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
 * - `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
 * - `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
 * Default to `PL1`.
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class InstanceDataDisk(
    public val autoSnapshotPolicyId: String? = null,
    public val category: String? = null,
    public val deleteWithInstance: Boolean? = null,
    public val description: String? = null,
    public val device: String? = null,
    public val encrypted: Boolean? = null,
    public val kmsKeyId: String? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: Int,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.InstanceDataDisk): InstanceDataDisk = InstanceDataDisk(
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId().map({ args0 -> args0 }).orElse(null),
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            device = javaType.device().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
