@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endTime The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
 * @property startTime The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
 */
public data class InstanceMaintenanceTime(
    public val endTime: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.InstanceMaintenanceTime): InstanceMaintenanceTime = InstanceMaintenanceTime(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
