@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property networkCardIndex The index of the network card for Secondary ENI.
 * @property networkInterfaceId The ID of the Secondary ENI.
 * @property networkInterfaceTrafficMode The communication mode of the Secondary ENI. Default value: `Standard`. Valid values:
 * - `Standard`: Uses the TCP communication mode.
 * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
 * @property queuePairNumber The number of queues supported by the ERI.
 * @property securityGroupIds The ID of security group N to which to assign Secondary ENI N.
 * @property vswitchId The ID of the vSwitch to which to connect Secondary ENI N.
 */
public data class InstanceNetworkInterfaces(
    public val networkCardIndex: Int? = null,
    public val networkInterfaceId: String? = null,
    public val networkInterfaceTrafficMode: String? = null,
    public val queuePairNumber: Int? = null,
    public val securityGroupIds: List<String>? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.InstanceNetworkInterfaces): InstanceNetworkInterfaces = InstanceNetworkInterfaces(
            networkCardIndex = javaType.networkCardIndex().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            networkInterfaceTrafficMode = javaType.networkInterfaceTrafficMode().map({ args0 ->
                args0
            }).orElse(null),
            queuePairNumber = javaType.queuePairNumber().map({ args0 -> args0 }).orElse(null),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
