@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the disk:
 * - cloud: Basic cloud disk.
 * - cloud_efficiency: Ultra cloud disk.
 * - cloud_ssd: SSD cloud Disks.
 * - ephemeral_ssd: local SSD Disks
 * - cloud_essd: ESSD cloud Disks.
 * Default to `cloud_efficiency`.
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
 * Default to true
 * @property description The description of the data disk.
 * @property encrypted Encrypted the data in this disk.
 * Default to false
 * @property name The name of the data disk.
 * @property performanceLevel
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class LaunchTemplateDataDisk(
    public val category: String? = null,
    public val deleteWithInstance: Boolean? = null,
    public val description: String? = null,
    public val encrypted: Boolean? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: Int? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.LaunchTemplateDataDisk): LaunchTemplateDataDisk = LaunchTemplateDataDisk(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
