@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the disk:
 * - cloud: Basic cloud disk.
 * - cloud_efficiency: Ultra cloud disk.
 * - cloud_ssd: SSD cloud Disks.
 * - ephemeral_ssd: local SSD Disks
 * - cloud_essd: ESSD cloud Disks.
 * Default to `cloud_efficiency`.
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
 * Default to true
 * @property description Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
 * @property encrypted Encrypted the data in this disk.
 * Default to false
 * @property iops
 * @property name Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
 * @property performanceLevel
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 */
public data class LaunchTemplateSystemDisk(
    public val category: String? = null,
    public val deleteWithInstance: Boolean? = null,
    public val description: String? = null,
    public val encrypted: Boolean? = null,
    public val iops: String? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.LaunchTemplateSystemDisk): LaunchTemplateSystemDisk = LaunchTemplateSystemDisk(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
