@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates an EDAS ecs application on EDAS, see [What is EDAS Application](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertapplication). The application will be deployed when `group_id` and `war_url` are given.
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: `${name}-${defaultInteger.result}`,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultCluster = new alicloud.edas.Cluster("default", {
 *     clusterName: `${name}-${defaultInteger.result}`,
 *     clusterType: 2,
 *     networkMode: 2,
 *     logicalRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultApplication = new alicloud.edas.Application("default", {
 *     applicationName: `${name}-${defaultInteger.result}`,
 *     clusterId: defaultCluster.id,
 *     packageType: "JAR",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.get_regions(current=True)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=f"{name}-{default_integer['result']}",
 *     cidr_block="10.4.0.0/16")
 * default_cluster = alicloud.edas.Cluster("default",
 *     cluster_name=f"{name}-{default_integer['result']}",
 *     cluster_type=2,
 *     network_mode=2,
 *     logical_region_id=default.regions[0].id,
 *     vpc_id=default_network.id)
 * default_application = alicloud.edas.Application("default",
 *     application_name=f"{name}-{default_integer['result']}",
 *     cluster_id=default_cluster.id,
 *     package_type="JAR")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = $"{name}-{defaultInteger.Result}",
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultCluster = new AliCloud.Edas.Cluster("default", new()
 *     {
 *         ClusterName = $"{name}-{defaultInteger.Result}",
 *         ClusterType = 2,
 *         NetworkMode = 2,
 *         LogicalRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultApplication = new AliCloud.Edas.Application("default", new()
 *     {
 *         ApplicationName = $"{name}-{defaultInteger.Result}",
 *         ClusterId = defaultCluster.Id,
 *         PackageType = "JAR",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := edas.NewCluster(ctx, "default", &edas.ClusterArgs{
 * 			ClusterName:     pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			ClusterType:     pulumi.Int(2),
 * 			NetworkMode:     pulumi.Int(2),
 * 			LogicalRegionId: pulumi.String(_default.Regions[0].Id),
 * 			VpcId:           defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = edas.NewApplication(ctx, "default", &edas.ApplicationArgs{
 * 			ApplicationName: pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			ClusterId:       defaultCluster.ID(),
 * 			PackageType:     pulumi.String("JAR"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.edas.Cluster;
 * import com.pulumi.alicloud.edas.ClusterArgs;
 * import com.pulumi.alicloud.edas.Application;
 * import com.pulumi.alicloud.edas.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(String.format("%s-%s", name,defaultInteger.result()))
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterName(String.format("%s-%s", name,defaultInteger.result()))
 *             .clusterType("2")
 *             .networkMode("2")
 *             .logicalRegionId(default_.regions()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .applicationName(String.format("%s-%s", name,defaultInteger.result()))
 *             .clusterId(defaultCluster.id())
 *             .packageType("JAR")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}-${defaultInteger.result}
 *       cidrBlock: 10.4.0.0/16
 *   defaultCluster:
 *     type: alicloud:edas:Cluster
 *     name: default
 *     properties:
 *       clusterName: ${name}-${defaultInteger.result}
 *       clusterType: '2'
 *       networkMode: '2'
 *       logicalRegionId: ${default.regions[0].id}
 *       vpcId: ${defaultNetwork.id}
 *   defaultApplication:
 *     type: alicloud:edas:Application
 *     name: default
 *     properties:
 *       applicationName: ${name}-${defaultInteger.result}
 *       clusterId: ${defaultCluster.id}
 *       packageType: JAR
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EDAS application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/application:Application app app_Id
 * ```
 * @property applicationName Name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
 * @property buildPackId The package ID of Enterprise Distributed Application Service (EDAS) Container, which can be retrieved by calling container version list interface ListBuildPack or the "Pack ID" column in container version list. When creating High-speed Service Framework (HSF) application, this parameter is required.
 * @property clusterId The ID of the cluster that you want to create the application. The default cluster will be used if you do not specify this parameter.
 * @property descriotion The description of the application that you want to create.
 * @property ecuInfos The ID of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
 * @property groupId The ID of the instance group where the application is going to be deployed. Set this parameter to all if you want to deploy the application to all groups.
 * @property healthCheckUrl The URL for health checking of the application.
 * @property logicalRegionId The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
 * @property packageType The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
 * @property packageVersion The version of the application that you want to deploy. It must be unique for every application. The length cannot exceed 64 characters. We recommended you to use a timestamp.
 * @property warUrl The address to store the uploaded web application (WAR) package for application deployment. This parameter is required when the deployType parameter is set as url.
 */
public data class ApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val buildPackId: Output<Int>? = null,
    public val clusterId: Output<String>? = null,
    public val descriotion: Output<String>? = null,
    public val ecuInfos: Output<List<String>>? = null,
    public val groupId: Output<String>? = null,
    public val healthCheckUrl: Output<String>? = null,
    public val logicalRegionId: Output<String>? = null,
    public val packageType: Output<String>? = null,
    public val packageVersion: Output<String>? = null,
    public val warUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.ApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.ApplicationArgs =
        com.pulumi.alicloud.edas.ApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .buildPackId(buildPackId?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .descriotion(descriotion?.applyValue({ args0 -> args0 }))
            .ecuInfos(ecuInfos?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .healthCheckUrl(healthCheckUrl?.applyValue({ args0 -> args0 }))
            .logicalRegionId(logicalRegionId?.applyValue({ args0 -> args0 }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .packageVersion(packageVersion?.applyValue({ args0 -> args0 }))
            .warUrl(warUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var buildPackId: Output<Int>? = null

    private var clusterId: Output<String>? = null

    private var descriotion: Output<String>? = null

    private var ecuInfos: Output<List<String>>? = null

    private var groupId: Output<String>? = null

    private var healthCheckUrl: Output<String>? = null

    private var logicalRegionId: Output<String>? = null

    private var packageType: Output<String>? = null

    private var packageVersion: Output<String>? = null

    private var warUrl: Output<String>? = null

    /**
     * @param value Name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
     */
    @JvmName("ytsehgwcpyxeckxo")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The package ID of Enterprise Distributed Application Service (EDAS) Container, which can be retrieved by calling container version list interface ListBuildPack or the "Pack ID" column in container version list. When creating High-speed Service Framework (HSF) application, this parameter is required.
     */
    @JvmName("wpsnmnpwmetjmoss")
    public suspend fun buildPackId(`value`: Output<Int>) {
        this.buildPackId = value
    }

    /**
     * @param value The ID of the cluster that you want to create the application. The default cluster will be used if you do not specify this parameter.
     */
    @JvmName("ssnhsuunapvpqbra")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The description of the application that you want to create.
     */
    @JvmName("hvpgctdytralvpdt")
    public suspend fun descriotion(`value`: Output<String>) {
        this.descriotion = value
    }

    /**
     * @param value The ID of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
     */
    @JvmName("rakydpdvaogyhylu")
    public suspend fun ecuInfos(`value`: Output<List<String>>) {
        this.ecuInfos = value
    }

    @JvmName("ifndtyonscdverca")
    public suspend fun ecuInfos(vararg values: Output<String>) {
        this.ecuInfos = Output.all(values.asList())
    }

    /**
     * @param values The ID of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
     */
    @JvmName("fygxtebbfoixpncp")
    public suspend fun ecuInfos(values: List<Output<String>>) {
        this.ecuInfos = Output.all(values)
    }

    /**
     * @param value The ID of the instance group where the application is going to be deployed. Set this parameter to all if you want to deploy the application to all groups.
     */
    @JvmName("rufwmunsofxyuxty")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The URL for health checking of the application.
     */
    @JvmName("ntnligkqjodqngbf")
    public suspend fun healthCheckUrl(`value`: Output<String>) {
        this.healthCheckUrl = value
    }

    /**
     * @param value The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
     */
    @JvmName("egxmwcpllrtvrrek")
    public suspend fun logicalRegionId(`value`: Output<String>) {
        this.logicalRegionId = value
    }

    /**
     * @param value The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
     */
    @JvmName("prqaggsxnabxsbfa")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value The version of the application that you want to deploy. It must be unique for every application. The length cannot exceed 64 characters. We recommended you to use a timestamp.
     */
    @JvmName("jeiwougnvomxtjns")
    public suspend fun packageVersion(`value`: Output<String>) {
        this.packageVersion = value
    }

    /**
     * @param value The address to store the uploaded web application (WAR) package for application deployment. This parameter is required when the deployType parameter is set as url.
     */
    @JvmName("iwkgaknchxixkccx")
    public suspend fun warUrl(`value`: Output<String>) {
        this.warUrl = value
    }

    /**
     * @param value Name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
     */
    @JvmName("sbtyhwvplfkkujrb")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The package ID of Enterprise Distributed Application Service (EDAS) Container, which can be retrieved by calling container version list interface ListBuildPack or the "Pack ID" column in container version list. When creating High-speed Service Framework (HSF) application, this parameter is required.
     */
    @JvmName("dbortumgcgefrfpn")
    public suspend fun buildPackId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildPackId = mapped
    }

    /**
     * @param value The ID of the cluster that you want to create the application. The default cluster will be used if you do not specify this parameter.
     */
    @JvmName("mrnbfqdlcempyhwa")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The description of the application that you want to create.
     */
    @JvmName("kgpxpunwfbybgkdl")
    public suspend fun descriotion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriotion = mapped
    }

    /**
     * @param value The ID of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
     */
    @JvmName("frnqvvjprakglbsw")
    public suspend fun ecuInfos(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecuInfos = mapped
    }

    /**
     * @param values The ID of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
     */
    @JvmName("aeejdhdxbitmskcm")
    public suspend fun ecuInfos(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecuInfos = mapped
    }

    /**
     * @param value The ID of the instance group where the application is going to be deployed. Set this parameter to all if you want to deploy the application to all groups.
     */
    @JvmName("fpcsdkoxjosgtcao")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The URL for health checking of the application.
     */
    @JvmName("jddxcbhklyddaayc")
    public suspend fun healthCheckUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckUrl = mapped
    }

    /**
     * @param value The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
     */
    @JvmName("vmibsqswrwjnkmjb")
    public suspend fun logicalRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalRegionId = mapped
    }

    /**
     * @param value The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
     */
    @JvmName("eylwtinoudbtlfbo")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value The version of the application that you want to deploy. It must be unique for every application. The length cannot exceed 64 characters. We recommended you to use a timestamp.
     */
    @JvmName("hudelraxgcwtpvee")
    public suspend fun packageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageVersion = mapped
    }

    /**
     * @param value The address to store the uploaded web application (WAR) package for application deployment. This parameter is required when the deployType parameter is set as url.
     */
    @JvmName("uxtefbulbrjwkwhu")
    public suspend fun warUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warUrl = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationName = applicationName,
        buildPackId = buildPackId,
        clusterId = clusterId,
        descriotion = descriotion,
        ecuInfos = ecuInfos,
        groupId = groupId,
        healthCheckUrl = healthCheckUrl,
        logicalRegionId = logicalRegionId,
        packageType = packageType,
        packageVersion = packageVersion,
        warUrl = warUrl,
    )
}
