@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ApplicationScale].
 */
@PulumiTagMarker
public class ApplicationScaleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationScaleArgs = ApplicationScaleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationScaleArgsBuilder.() -> Unit) {
        val builder = ApplicationScaleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationScale {
        val builtJavaResource = com.pulumi.alicloud.edas.ApplicationScale(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationScale(builtJavaResource)
    }
}

/**
 * This operation is provided to scale out an EDAS application, see [What is EDAS Application Scale](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-scaleoutapplication).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_[0-9]+_[0-9]+_x64*",
 *     owners: "system",
 * });
 * const defaultGetInstanceTypes = defaultGetZones.then(defaultGetZones => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: defaultGetZones.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *     instanceName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 *     internetMaxBandwidthOut: 10,
 *     internetChargeType: "PayByTraffic",
 *     instanceChargeType: "PostPaid",
 *     systemDiskCategory: "cloud_efficiency",
 * });
 * const defaultCluster = new alicloud.edas.Cluster("default", {
 *     clusterName: name,
 *     clusterType: 2,
 *     networkMode: 2,
 *     logicalRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstanceClusterAttachment = new alicloud.edas.InstanceClusterAttachment("default", {
 *     clusterId: defaultCluster.id,
 *     instanceIds: [defaultInstance&#46;id],
 * });
 * const defaultApplication = new alicloud.edas.Application("default", {
 *     applicationName: name,
 *     clusterId: defaultCluster.id,
 *     packageType: "WAR",
 * });
 * const defaultDeployGroup = new alicloud.edas.DeployGroup("default", {
 *     appId: defaultApplication.id,
 *     groupName: name,
 * });
 * const defaultGetDeployGroups = alicloud.edas.getDeployGroupsOutput({
 *     appId: defaultDeployGroup.appId,
 * });
 * const defaultApplicationScale = new alicloud.edas.ApplicationScale("default", {
 *     appId: defaultApplication.id,
 *     deployGroup: defaultGetDeployGroups.apply(defaultGetDeployGroups => defaultGetDeployGroups.groups?.[0]?.groupId),
 *     ecuInfos: [pulumi&#46;all([defaultInstanceClusterAttachment&#46;ecuMap, defaultInstance&#46;id])&#46;apply(([ecuMap, id]) => ecuMap[id])],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
 *     owners="system")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_get_zones.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default_get_zones.zones[0].id,
 *     instance_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id,
 *     internet_max_bandwidth_out=10,
 *     internet_charge_type="PayByTraffic",
 *     instance_charge_type="PostPaid",
 *     system_disk_category="cloud_efficiency")
 * default_cluster = alicloud.edas.Cluster("default",
 *     cluster_name=name,
 *     cluster_type=2,
 *     network_mode=2,
 *     logical_region_id=default.regions[0].id,
 *     vpc_id=default_network.id)
 * default_instance_cluster_attachment = alicloud.edas.InstanceClusterAttachment("default",
 *     cluster_id=default_cluster.id,
 *     instance_ids=[default_instance&#46;id])
 * default_application = alicloud.edas.Application("default",
 *     application_name=name,
 *     cluster_id=default_cluster.id,
 *     package_type="WAR")
 * default_deploy_group = alicloud.edas.DeployGroup("default",
 *     app_id=default_application.id,
 *     group_name=name)
 * default_get_deploy_groups = alicloud.edas.get_deploy_groups_output(app_id=default_deploy_group.app_id)
 * default_application_scale = alicloud.edas.ApplicationScale("default",
 *     app_id=default_application.id,
 *     deploy_group=default_get_deploy_groups.groups[0].group_id,
 *     ecu_infos=[pulumi.Output.all(
 *         ecu_map=default_instance_cluster_attachment.ecu_map,
 *         id=default_instance.id
 * ).apply(lambda resolved_outputs: resolved_outputs['ecu_map'][resolved_outputs['id']])
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_[0-9]+_[0-9]+_x64*",
 *         Owners = "system",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         InstanceName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *         InternetMaxBandwidthOut = 10,
 *         InternetChargeType = "PayByTraffic",
 *         InstanceChargeType = "PostPaid",
 *         SystemDiskCategory = "cloud_efficiency",
 *     });
 *     var defaultCluster = new AliCloud.Edas.Cluster("default", new()
 *     {
 *         ClusterName = name,
 *         ClusterType = 2,
 *         NetworkMode = 2,
 *         LogicalRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstanceClusterAttachment = new AliCloud.Edas.InstanceClusterAttachment("default", new()
 *     {
 *         ClusterId = defaultCluster.Id,
 *         InstanceIds = new[]
 *         {
 *             defaultInstance.Id,
 *         },
 *     });
 *     var defaultApplication = new AliCloud.Edas.Application("default", new()
 *     {
 *         ApplicationName = name,
 *         ClusterId = defaultCluster.Id,
 *         PackageType = "WAR",
 *     });
 *     var defaultDeployGroup = new AliCloud.Edas.DeployGroup("default", new()
 *     {
 *         AppId = defaultApplication.Id,
 *         GroupName = name,
 *     });
 *     var defaultGetDeployGroups = AliCloud.Edas.GetDeployGroups.Invoke(new()
 *     {
 *         AppId = defaultDeployGroup.AppId,
 *     });
 *     var defaultApplicationScale = new AliCloud.Edas.ApplicationScale("default", new()
 *     {
 *         AppId = defaultApplication.Id,
 *         DeployGroup = defaultGetDeployGroups.Apply(getDeployGroupsResult => getDeployGroupsResult.Groups[0]?.GroupId),
 *         EcuInfos = new[]
 *         {
 *             Output.Tuple(defaultInstanceClusterAttachment.EcuMap, defaultInstance.Id).Apply(values =>
 *             {
 *                 var ecuMap = values.Item1;
 *                 var id = values.Item2;
 *                 return ecuMap[id];
 *             }),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_[0-9]+_[0-9]+_x64*"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(defaultGetZones.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(defaultGetZones.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId:               defaultSwitch.ID(),
 * 			InternetMaxBandwidthOut: pulumi.Int(10),
 * 			InternetChargeType:      pulumi.String("PayByTraffic"),
 * 			InstanceChargeType:      pulumi.String("PostPaid"),
 * 			SystemDiskCategory:      pulumi.String("cloud_efficiency"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := edas.NewCluster(ctx, "default", &edas.ClusterArgs{
 * 			ClusterName:     pulumi.String(name),
 * 			ClusterType:     pulumi.Int(2),
 * 			NetworkMode:     pulumi.Int(2),
 * 			LogicalRegionId: pulumi.String(_default.Regions[0].Id),
 * 			VpcId:           defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstanceClusterAttachment, err := edas.NewInstanceClusterAttachment(ctx, "default", &edas.InstanceClusterAttachmentArgs{
 * 			ClusterId: defaultCluster.ID(),
 * 			InstanceIds: pulumi.StringArray{
 * 				defaultInstance.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultApplication, err := edas.NewApplication(ctx, "default", &edas.ApplicationArgs{
 * 			ApplicationName: pulumi.String(name),
 * 			ClusterId:       defaultCluster.ID(),
 * 			PackageType:     pulumi.String("WAR"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDeployGroup, err := edas.NewDeployGroup(ctx, "default", &edas.DeployGroupArgs{
 * 			AppId:     defaultApplication.ID(),
 * 			GroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetDeployGroups := edas.GetDeployGroupsOutput(ctx, edas.GetDeployGroupsOutputArgs{
 * 			AppId: defaultDeployGroup.AppId,
 * 		}, nil)
 * 		_, err = edas.NewApplicationScale(ctx, "default", &edas.ApplicationScaleArgs{
 * 			AppId: defaultApplication.ID(),
 * 			DeployGroup: pulumi.String(defaultGetDeployGroups.ApplyT(func(defaultGetDeployGroups edas.GetDeployGroupsResult) (*string, error) {
 * 				return &defaultGetDeployGroups.Groups[0].GroupId, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			EcuInfos: pulumi.StringArray{
 * 				pulumi.All(defaultInstanceClusterAttachment.EcuMap, defaultInstance.ID()).ApplyT(func(_args []interface{}) (string, error) {
 * 					ecuMap := _args[0]&#46;(map[string]string)
 * 					id := _args[1].(string)
 * 					return ecuMap[id], nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.edas.Cluster;
 * import com.pulumi.alicloud.edas.ClusterArgs;
 * import com.pulumi.alicloud.edas.InstanceClusterAttachment;
 * import com.pulumi.alicloud.edas.InstanceClusterAttachmentArgs;
 * import com.pulumi.alicloud.edas.Application;
 * import com.pulumi.alicloud.edas.ApplicationArgs;
 * import com.pulumi.alicloud.edas.DeployGroup;
 * import com.pulumi.alicloud.edas.DeployGroupArgs;
 * import com.pulumi.alicloud.edas.EdasFunctions;
 * import com.pulumi.alicloud.edas.inputs.GetDeployGroupsArgs;
 * import com.pulumi.alicloud.edas.ApplicationScale;
 * import com.pulumi.alicloud.edas.ApplicationScaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_[0-9]+_[0-9]+_x64*")
 *             .owners("system")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .instanceName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .internetMaxBandwidthOut("10")
 *             .internetChargeType("PayByTraffic")
 *             .instanceChargeType("PostPaid")
 *             .systemDiskCategory("cloud_efficiency")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterName(name)
 *             .clusterType("2")
 *             .networkMode("2")
 *             .logicalRegionId(default_.regions()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstanceClusterAttachment = new InstanceClusterAttachment("defaultInstanceClusterAttachment", InstanceClusterAttachmentArgs.builder()
 *             .clusterId(defaultCluster.id())
 *             .instanceIds(defaultInstance.id())
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .applicationName(name)
 *             .clusterId(defaultCluster.id())
 *             .packageType("WAR")
 *             .build());
 *         var defaultDeployGroup = new DeployGroup("defaultDeployGroup", DeployGroupArgs.builder()
 *             .appId(defaultApplication.id())
 *             .groupName(name)
 *             .build());
 *         final var defaultGetDeployGroups = EdasFunctions.getDeployGroups(GetDeployGroupsArgs.builder()
 *             .appId(defaultDeployGroup.appId())
 *             .build());
 *         var defaultApplicationScale = new ApplicationScale("defaultApplicationScale", ApplicationScaleArgs.builder()
 *             .appId(defaultApplication.id())
 *             .deployGroup(defaultGetDeployGroups.applyValue(getDeployGroupsResult -> getDeployGroupsResult).applyValue(defaultGetDeployGroups -> defaultGetDeployGroups.applyValue(getDeployGroupsResult -> getDeployGroupsResult.groups()[0].groupId())))
 *             .ecuInfos(Output.tuple(defaultInstanceClusterAttachment.ecuMap(), defaultInstance.id()).applyValue(values -> {
 *                 var ecuMap = values.t1;
 *                 var id = values.t2;
 *                 return ecuMap[id];
 *             }))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ApplicationScale internal constructor(
    override val javaResource: com.pulumi.alicloud.edas.ApplicationScale,
) : KotlinCustomResource(javaResource, ApplicationScaleMapper) {
    /**
     * The ID of the application that you want to deploy.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance group to which you want to add ECS instances to scale out the application.
     */
    public val deployGroup: Output<String>
        get() = javaResource.deployGroup().applyValue({ args0 -> args0 })

    /**
     * The ecc information of the resource supplied above. The value is formulated as `<ecc1,ecc2>`.
     */
    public val eccInfo: Output<String>
        get() = javaResource.eccInfo().applyValue({ args0 -> args0 })

    /**
     * The IDs of the Elastic Compute Unit (ECU) where you want to deploy the application. Type: List.
     */
    public val ecuInfos: Output<List<String>>
        get() = javaResource.ecuInfos().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * This parameter specifies whether to forcibly remove an ECS instance where the application is deployed. It is set as true only after the ECS instance expires. In normal cases, this parameter do not need to be specified.
     */
    public val forceStatus: Output<Boolean>?
        get() = javaResource.forceStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ApplicationScaleMapper : ResourceMapper<ApplicationScale> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.edas.ApplicationScale::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationScale = ApplicationScale(
        javaResource as
            com.pulumi.alicloud.edas.ApplicationScale,
    )
}

/**
 * @see [ApplicationScale].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationScale].
 */
public suspend fun applicationScale(
    name: String,
    block: suspend ApplicationScaleResourceBuilder.() -> Unit,
): ApplicationScale {
    val builder = ApplicationScaleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationScale].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationScale(name: String): ApplicationScale {
    val builder = ApplicationScaleResourceBuilder()
    builder.name(name)
    return builder.build()
}
