@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an EDAS cluster resource, see [What is EDAS Cluster](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertcluster).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultCluster = new alicloud.edas.Cluster("default", {
 *     clusterName: name,
 *     clusterType: 2,
 *     networkMode: 2,
 *     logicalRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_cluster = alicloud.edas.Cluster("default",
 *     cluster_name=name,
 *     cluster_type=2,
 *     network_mode=2,
 *     logical_region_id=default.regions[0].id,
 *     vpc_id=default_network.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultCluster = new AliCloud.Edas.Cluster("default", new()
 *     {
 *         ClusterName = name,
 *         ClusterType = 2,
 *         NetworkMode = 2,
 *         LogicalRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = edas.NewCluster(ctx, "default", &edas.ClusterArgs{
 * 			ClusterName:     pulumi.String(name),
 * 			ClusterType:     pulumi.Int(2),
 * 			NetworkMode:     pulumi.Int(2),
 * 			LogicalRegionId: pulumi.String(_default.Regions[0].Id),
 * 			VpcId:           defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.edas.Cluster;
 * import com.pulumi.alicloud.edas.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterName(name)
 *             .clusterType("2")
 *             .networkMode("2")
 *             .logicalRegionId(default_.regions()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultCluster:
 *     type: alicloud:edas:Cluster
 *     name: default
 *     properties:
 *       clusterName: ${name}
 *       clusterType: '2'
 *       networkMode: '2'
 *       logicalRegionId: ${default.regions[0].id}
 *       vpcId: ${defaultNetwork.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EDAS cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/cluster:Cluster cluster cluster_id
 * ```
 * @property clusterName The name of the cluster that you want to create.
 * @property clusterType The type of the cluster that you want to create. Valid values only: 2: ECS cluster.
 * @property logicalRegionId The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
 * @property networkMode The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
 * @property vpcId The ID of the Virtual Private Cloud (VPC) for the cluster.
 */
public data class ClusterArgs(
    public val clusterName: Output<String>? = null,
    public val clusterType: Output<Int>? = null,
    public val logicalRegionId: Output<String>? = null,
    public val networkMode: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.ClusterArgs =
        com.pulumi.alicloud.edas.ClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .logicalRegionId(logicalRegionId?.applyValue({ args0 -> args0 }))
            .networkMode(networkMode?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var clusterType: Output<Int>? = null

    private var logicalRegionId: Output<String>? = null

    private var networkMode: Output<Int>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The name of the cluster that you want to create.
     */
    @JvmName("nhptrmmydrsfdntu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The type of the cluster that you want to create. Valid values only: 2: ECS cluster.
     */
    @JvmName("egxrglgosnmjoqmh")
    public suspend fun clusterType(`value`: Output<Int>) {
        this.clusterType = value
    }

    /**
     * @param value The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
     */
    @JvmName("yqbkkrlswwxedmcu")
    public suspend fun logicalRegionId(`value`: Output<String>) {
        this.logicalRegionId = value
    }

    /**
     * @param value The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
     */
    @JvmName("hnlrrvghhnxydryy")
    public suspend fun networkMode(`value`: Output<Int>) {
        this.networkMode = value
    }

    /**
     * @param value The ID of the Virtual Private Cloud (VPC) for the cluster.
     */
    @JvmName("yyowaaefewtrqduy")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The name of the cluster that you want to create.
     */
    @JvmName("xmfcunidjiyeadpo")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The type of the cluster that you want to create. Valid values only: 2: ECS cluster.
     */
    @JvmName("mxqerpvqhpioedci")
    public suspend fun clusterType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The ID of the namespace where you want to create the application. You can call the ListUserDefineRegion operation to query the namespace ID.
     */
    @JvmName("ifrphbthpuowmpbn")
    public suspend fun logicalRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalRegionId = mapped
    }

    /**
     * @param value The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
     */
    @JvmName("mkfffywgpyadubxq")
    public suspend fun networkMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkMode = mapped
    }

    /**
     * @param value The ID of the Virtual Private Cloud (VPC) for the cluster.
     */
    @JvmName("rpkwxdgumvaelbiq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        clusterName = clusterName,
        clusterType = clusterType,
        logicalRegionId = logicalRegionId,
        networkMode = networkMode,
        vpcId = vpcId,
    )
}
