@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.EdasFunctions.getApplicationsPlain
import com.pulumi.alicloud.edas.EdasFunctions.getClustersPlain
import com.pulumi.alicloud.edas.EdasFunctions.getDeployGroupsPlain
import com.pulumi.alicloud.edas.EdasFunctions.getNamespacesPlain
import com.pulumi.alicloud.edas.EdasFunctions.getServicePlain
import com.pulumi.alicloud.edas.kotlin.inputs.GetApplicationsPlainArgs
import com.pulumi.alicloud.edas.kotlin.inputs.GetApplicationsPlainArgsBuilder
import com.pulumi.alicloud.edas.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.edas.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.edas.kotlin.inputs.GetDeployGroupsPlainArgs
import com.pulumi.alicloud.edas.kotlin.inputs.GetDeployGroupsPlainArgsBuilder
import com.pulumi.alicloud.edas.kotlin.inputs.GetNamespacesPlainArgs
import com.pulumi.alicloud.edas.kotlin.inputs.GetNamespacesPlainArgsBuilder
import com.pulumi.alicloud.edas.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.edas.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.edas.kotlin.outputs.GetApplicationsResult
import com.pulumi.alicloud.edas.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.edas.kotlin.outputs.GetDeployGroupsResult
import com.pulumi.alicloud.edas.kotlin.outputs.GetNamespacesResult
import com.pulumi.alicloud.edas.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.edas.kotlin.outputs.GetApplicationsResult.Companion.toKotlin as getApplicationsResultToKotlin
import com.pulumi.alicloud.edas.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.edas.kotlin.outputs.GetDeployGroupsResult.Companion.toKotlin as getDeployGroupsResultToKotlin
import com.pulumi.alicloud.edas.kotlin.outputs.GetNamespacesResult.Companion.toKotlin as getNamespacesResultToKotlin
import com.pulumi.alicloud.edas.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object EdasFunctions {
    /**
     * This data source provides a list of EDAS application in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.82.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const applications = alicloud.edas.getApplications({
     *     ids: ["xxx"],
     *     outputFile: "application.txt",
     * });
     * export const firstApplicationName = applications.then(applications => applications.applications?.[0]?.appName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * applications = alicloud.edas.get_applications(ids=["xxx"],
     *     output_file="application.txt")
     * pulumi.export("firstApplicationName", applications.applications[0].app_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var applications = AliCloud.Edas.GetApplications.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "xxx",
     *         },
     *         OutputFile = "application.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstApplicationName"] = applications&#46;Apply(getApplicationsResult => getApplicationsResult&#46;Applications[0]?.AppName),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		applications, err := edas.GetApplications(ctx, &edas.GetApplicationsArgs{
     * 			Ids: []string{
     * 				"xxx",
     * 			},
     * 			OutputFile: pulumi.StringRef("application.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstApplicationName", applications.Applications[0].AppName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.edas.EdasFunctions;
     * import com.pulumi.alicloud.edas.inputs.GetApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var applications = EdasFunctions.getApplications(GetApplicationsArgs.builder()
     *             .ids("xxx")
     *             .outputFile("application.txt")
     *             .build());
     *         ctx.export("firstApplicationName", applications.applyValue(getApplicationsResult -> getApplicationsResult.applications()[0].appName()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   applications:
     *     fn::invoke:
     *       Function: alicloud:edas:getApplications
     *       Arguments:
     *         ids:
     *           - xxx
     *         outputFile: application.txt
     * outputs:
     *   firstApplicationName: ${applications.applications[0].appName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplications.
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: GetApplicationsPlainArgs): GetApplicationsResult =
        getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getApplications].
     * @param ids An ids string to filter results by the application id.
     * @param nameRegex A regex string to filter results by the application name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetApplicationsResult {
        val argument = GetApplicationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;edas&#46;kotlin&#46;inputs&#46;GetApplicationsPlainArgs].
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: suspend GetApplicationsPlainArgsBuilder.() -> Unit): GetApplicationsResult {
        val builder = GetApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationsResultToKotlin(getApplicationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of EDAS clusters in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.82.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const clusters = alicloud.edas.getClusters({
     *     logicalRegionId: "cn-shenzhen:xxx",
     *     ids: ["addfs-dfsasd"],
     *     outputFile: "clusters.txt",
     * });
     * export const firstClusterName = clustersAlicloudAlikafkaConsumerGroups.clusters[0].clusterName;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * clusters = alicloud.edas.get_clusters(logical_region_id="cn-shenzhen:xxx",
     *     ids=["addfs-dfsasd"],
     *     output_file="clusters.txt")
     * pulumi.export("firstClusterName", clusters_alicloud_alikafka_consumer_groups["clusters"][0]["clusterName"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var clusters = AliCloud.Edas.GetClusters.Invoke(new()
     *     {
     *         LogicalRegionId = "cn-shenzhen:xxx",
     *         Ids = new[]
     *         {
     *             "addfs-dfsasd",
     *         },
     *         OutputFile = "clusters.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstClusterName"] = clustersAlicloudAlikafkaConsumerGroups&#46;Clusters[0].ClusterName,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := edas.GetClusters(ctx, &edas.GetClustersArgs{
     * 			LogicalRegionId: "cn-shenzhen:xxx",
     * 			Ids: []string{
     * 				"addfs-dfsasd",
     * 			},
     * 			OutputFile: pulumi.StringRef("clusters.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstClusterName", clustersAlicloudAlikafkaConsumerGroups.Clusters[0].ClusterName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.edas.EdasFunctions;
     * import com.pulumi.alicloud.edas.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var clusters = EdasFunctions.getClusters(GetClustersArgs.builder()
     *             .logicalRegionId("cn-shenzhen:xxx")
     *             .ids("addfs-dfsasd")
     *             .outputFile("clusters.txt")
     *             .build());
     *         ctx.export("firstClusterName", clustersAlicloudAlikafkaConsumerGroups.clusters()[0].clusterName());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   clusters:
     *     fn::invoke:
     *       Function: alicloud:edas:getClusters
     *       Arguments:
     *         logicalRegionId: cn-shenzhen:xxx
     *         ids:
     *           - addfs-dfsasd
     *         outputFile: clusters.txt
     * outputs:
     *   firstClusterName: ${clustersAlicloudAlikafkaConsumerGroups.clusters[0].clusterName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param ids An ids string to filter results by the cluster id.
     * @param logicalRegionId ID of the namespace in EDAS.
     * @param nameRegex A regex string to filter results by the cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        ids: List<String>? = null,
        logicalRegionId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            ids = ids,
            logicalRegionId = logicalRegionId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;edas&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of EDAS deploy groups in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.82.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.edas.EdasFunctions;
     * import com.pulumi.alicloud.edas.inputs.GetDeployGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var groups = EdasFunctions.getDeployGroups(GetDeployGroupsArgs.builder()
     *             .appId("xxx")
     *             .ids("xxx")
     *             .outputFile("groups.txt")
     *             .build());
     *         ctx.export("firstGroupName", groups.applyValue(getDeployGroupsResult -> getDeployGroupsResult.groups()[0].groupName()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   groups:
     *     fn::invoke:
     *       Function: alicloud:edas:getDeployGroups
     *       Arguments:
     *         appId: xxx
     *         ids:
     *           - xxx
     *         outputFile: groups.txt
     * outputs:
     *   firstGroupName: ${groups.groups[0].groupName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDeployGroups.
     * @return A collection of values returned by getDeployGroups.
     */
    public suspend fun getDeployGroups(argument: GetDeployGroupsPlainArgs): GetDeployGroupsResult =
        getDeployGroupsResultToKotlin(getDeployGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDeployGroups].
     * @param appId ID of the EDAS application.
     * @param nameRegex A regex string to filter results by the deploy group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDeployGroups.
     */
    public suspend fun getDeployGroups(
        appId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDeployGroupsResult {
        val argument = GetDeployGroupsPlainArgs(
            appId = appId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDeployGroupsResultToKotlin(getDeployGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeployGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;edas&#46;kotlin&#46;inputs&#46;GetDeployGroupsPlainArgs].
     * @return A collection of values returned by getDeployGroups.
     */
    public suspend fun getDeployGroups(argument: suspend GetDeployGroupsPlainArgsBuilder.() -> Unit): GetDeployGroupsResult {
        val builder = GetDeployGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeployGroupsResultToKotlin(getDeployGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Edas Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.173.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.edas.getNamespaces({
     *     ids: ["example_id"],
     * });
     * export const edasNamespaceId1 = ids.then(ids => ids.namespaces?.[0]?.id);
     * const nameRegex = alicloud.edas.getNamespaces({
     *     nameRegex: "^my-Namespace",
     * });
     * export const edasNamespaceId2 = nameRegex.then(nameRegex => nameRegex.namespaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.edas.get_namespaces(ids=["example_id"])
     * pulumi.export("edasNamespaceId1", ids.namespaces[0].id)
     * name_regex = alicloud.edas.get_namespaces(name_regex="^my-Namespace")
     * pulumi.export("edasNamespaceId2", name_regex.namespaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Edas.GetNamespaces.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Edas.GetNamespaces.Invoke(new()
     *     {
     *         NameRegex = "^my-Namespace",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["edasNamespaceId1"] = ids&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *         ["edasNamespaceId2"] = nameRegex&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := edas.GetNamespaces(ctx, &edas.GetNamespacesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("edasNamespaceId1", ids.Namespaces[0].Id)
     * 		nameRegex, err := edas.GetNamespaces(ctx, &edas.GetNamespacesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Namespace"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("edasNamespaceId2", nameRegex.Namespaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.edas.EdasFunctions;
     * import com.pulumi.alicloud.edas.inputs.GetNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdasFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("edasNamespaceId1", ids.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *         final var nameRegex = EdasFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .nameRegex("^my-Namespace")
     *             .build());
     *         ctx.export("edasNamespaceId2", nameRegex.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:edas:getNamespaces
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:edas:getNamespaces
     *       Arguments:
     *         nameRegex: ^my-Namespace
     * outputs:
     *   edasNamespaceId1: ${ids.namespaces[0].id}
     *   edasNamespaceId2: ${nameRegex.namespaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespaces.
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: GetNamespacesPlainArgs): GetNamespacesResult =
        getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaces].
     * @param ids A list of Namespace IDs.
     * @param nameRegex A regex string to filter results by Namespace name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetNamespacesResult {
        val argument = GetNamespacesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;edas&#46;kotlin&#46;inputs&#46;GetNamespacesPlainArgs].
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: suspend GetNamespacesPlainArgsBuilder.() -> Unit): GetNamespacesResult {
        val builder = GetNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespacesResultToKotlin(getNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open EDAS service automatically. If the service has been opened, it will return opened.
     * For information about EDAS and how to use it, see [What is EDAS](https://www.alibabacloud.com/help/product/29500.htm).
     * > **NOTE:** Available in v1.98.0+
     * > **NOTE:** The EDAS service is not support to be open automatically in the international site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.edas.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.edas.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Edas.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := edas.GetService(ctx, &edas.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.edas.EdasFunctions;
     * import com.pulumi.alicloud.edas.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = EdasFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:edas:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the EDAS service that means you have read and agreed the [EDAS Terms of Service](https://help.aliyun.com/document_detail/44633.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;edas&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
