@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [K8sApplication].
 */
@PulumiTagMarker
public class K8sApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: K8sApplicationArgs = K8sApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend K8sApplicationArgsBuilder.() -> Unit) {
        val builder = K8sApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): K8sApplication {
        val builtJavaResource = com.pulumi.alicloud.edas.K8sApplication(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return K8sApplication(builtJavaResource)
    }
}

/**
 * Create an EDAS k8s application.For information about EDAS K8s Application and how to use it, see [What is EDAS K8s Application](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertk8sapplication).
 * > **NOTE:** Available since v1.105.0.
 * ## Import
 * EDAS k8s application can be imported as below, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sApplication:K8sApplication new_k8s_application application_id
 * ```
 */
public class K8sApplication internal constructor(
    override val javaResource: com.pulumi.alicloud.edas.K8sApplication,
) : KotlinCustomResource(javaResource, K8sApplicationMapper) {
    /**
     * The description of the application
     */
    public val applicationDescriotion: Output<String>?
        get() = javaResource.applicationDescriotion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The set command, if set, will replace the startup command in the mirror when the mirror is started.
     */
    public val command: Output<String>?
        get() = javaResource.command().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
     */
    public val commandArgs: Output<List<String>>?
        get() = javaResource.commandArgs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * EDAS-Container version that the deployed package depends on. Image does not support this parameter.
     */
    public val edasContainerVersion: Output<String>?
        get() = javaResource.edasContainerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
     */
    public val envs: Output<Map<String, String>>?
        get() = javaResource.envs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Mirror address. When the package_type is set to 'Image', this parameter item is required.
     */
    public val imageUrl: Output<String>?
        get() = javaResource.imageUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbId: Output<String>?
        get() = javaResource.internetSlbId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbPort: Output<Int>?
        get() = javaResource.internetSlbPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbProtocol: Output<String>?
        get() = javaResource.internetSlbProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetTargetPort: Output<Int>?
        get() = javaResource.internetTargetPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
     */
    public val jdk: Output<String>?
        get() = javaResource.jdk().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
     */
    public val limitMCpu: Output<Int>?
        get() = javaResource.limitMCpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The memory limit of the application instance during application operation, unit: M.
     */
    public val limitMem: Output<Int>?
        get() = javaResource.limitMem().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
     */
    public val liveness: Output<String>?
        get() = javaResource.liveness().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
     */
    public val localVolume: Output<String>?
        get() = javaResource.localVolume().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
     */
    public val logicalRegionId: Output<String>?
        get() = javaResource.logicalRegionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
     */
    public val mountDescs: Output<String>?
        get() = javaResource.mountDescs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
     */
    public val nasId: Output<String>?
        get() = javaResource.nasId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Application package type. Optional parameter values include: FatJar, WAR and Image.
     */
    public val packageType: Output<String>?
        get() = javaResource.packageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
     */
    public val packageUrl: Output<String>?
        get() = javaResource.packageUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
     */
    public val packageVersion: Output<String>
        get() = javaResource.packageVersion().applyValue({ args0 -> args0 })

    /**
     * Execute script after startup
     */
    public val postStart: Output<String>?
        get() = javaResource.postStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Execute script before stopping
     */
    public val preStop: Output<String>?
        get() = javaResource.preStop().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
     */
    public val readiness: Output<String>?
        get() = javaResource.readiness().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of application instances.
     */
    public val replicas: Output<Int>?
        get() = javaResource.replicas().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
     */
    public val requestsMCpu: Output<Int>?
        get() = javaResource.requestsMCpu().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
     */
    public val requestsMem: Output<Int>?
        get() = javaResource.requestsMem().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
     */
    public val webContainer: Output<String>?
        get() = javaResource.webContainer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object K8sApplicationMapper : ResourceMapper<K8sApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.edas.K8sApplication::class == javaResource::class

    override fun map(javaResource: Resource): K8sApplication = K8sApplication(
        javaResource as
            com.pulumi.alicloud.edas.K8sApplication,
    )
}

/**
 * @see [K8sApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [K8sApplication].
 */
public suspend fun k8sApplication(
    name: String,
    block: suspend K8sApplicationResourceBuilder.() -> Unit,
): K8sApplication {
    val builder = K8sApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [K8sApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun k8sApplication(name: String): K8sApplication {
    val builder = K8sApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
