@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.K8sApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Create an EDAS k8s application.For information about EDAS K8s Application and how to use it, see [What is EDAS K8s Application](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertk8sapplication).
 * > **NOTE:** Available since v1.105.0.
 * ## Import
 * EDAS k8s application can be imported as below, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sApplication:K8sApplication new_k8s_application application_id
 * ```
 * @property applicationDescriotion The description of the application
 * @property applicationName The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
 * @property clusterId The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
 * @property command The set command, if set, will replace the startup command in the mirror when the mirror is started.
 * @property commandArgs Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
 * @property edasContainerVersion EDAS-Container version that the deployed package depends on. Image does not support this parameter.
 * @property envs Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
 * @property imageUrl Mirror address. When the package_type is set to 'Image', this parameter item is required.
 * @property internetSlbId Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
 * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
 * @property internetSlbPort The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
 * @property internetSlbProtocol The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
 * @property internetTargetPort The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
 * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
 * @property jdk The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
 * @property limitMCpu The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
 * @property limitMem The memory limit of the application instance during application operation, unit: M.
 * @property liveness Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
 * @property localVolume The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
 * @property logicalRegionId The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
 * @property mountDescs Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
 * @property namespace The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
 * @property nasId The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
 * @property packageType Application package type. Optional parameter values include: FatJar, WAR and Image.
 * @property packageUrl The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
 * @property packageVersion The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
 * @property postStart Execute script after startup
 * @property preStop Execute script before stopping
 * @property readiness Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
 * @property replicas Number of application instances.
 * @property requestsMCpu When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
 * @property requestsMem When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
 * @property webContainer The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
 */
public data class K8sApplicationArgs(
    public val applicationDescriotion: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val command: Output<String>? = null,
    public val commandArgs: Output<List<String>>? = null,
    public val edasContainerVersion: Output<String>? = null,
    public val envs: Output<Map<String, String>>? = null,
    public val imageUrl: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbPort: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetSlbProtocol: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    public val internetTargetPort: Output<Int>? = null,
    public val jdk: Output<String>? = null,
    public val limitMCpu: Output<Int>? = null,
    public val limitMem: Output<Int>? = null,
    public val liveness: Output<String>? = null,
    public val localVolume: Output<String>? = null,
    public val logicalRegionId: Output<String>? = null,
    public val mountDescs: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val nasId: Output<String>? = null,
    public val packageType: Output<String>? = null,
    public val packageUrl: Output<String>? = null,
    public val packageVersion: Output<String>? = null,
    public val postStart: Output<String>? = null,
    public val preStop: Output<String>? = null,
    public val readiness: Output<String>? = null,
    public val replicas: Output<Int>? = null,
    public val requestsMCpu: Output<Int>? = null,
    public val requestsMem: Output<Int>? = null,
    public val webContainer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.K8sApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.K8sApplicationArgs =
        com.pulumi.alicloud.edas.K8sApplicationArgs.builder()
            .applicationDescriotion(applicationDescriotion?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .command(command?.applyValue({ args0 -> args0 }))
            .commandArgs(commandArgs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .edasContainerVersion(edasContainerVersion?.applyValue({ args0 -> args0 }))
            .envs(envs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .internetSlbId(internetSlbId?.applyValue({ args0 -> args0 }))
            .internetSlbPort(internetSlbPort?.applyValue({ args0 -> args0 }))
            .internetSlbProtocol(internetSlbProtocol?.applyValue({ args0 -> args0 }))
            .internetTargetPort(internetTargetPort?.applyValue({ args0 -> args0 }))
            .jdk(jdk?.applyValue({ args0 -> args0 }))
            .limitMCpu(limitMCpu?.applyValue({ args0 -> args0 }))
            .limitMem(limitMem?.applyValue({ args0 -> args0 }))
            .liveness(liveness?.applyValue({ args0 -> args0 }))
            .localVolume(localVolume?.applyValue({ args0 -> args0 }))
            .logicalRegionId(logicalRegionId?.applyValue({ args0 -> args0 }))
            .mountDescs(mountDescs?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .nasId(nasId?.applyValue({ args0 -> args0 }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .packageUrl(packageUrl?.applyValue({ args0 -> args0 }))
            .packageVersion(packageVersion?.applyValue({ args0 -> args0 }))
            .postStart(postStart?.applyValue({ args0 -> args0 }))
            .preStop(preStop?.applyValue({ args0 -> args0 }))
            .readiness(readiness?.applyValue({ args0 -> args0 }))
            .replicas(replicas?.applyValue({ args0 -> args0 }))
            .requestsMCpu(requestsMCpu?.applyValue({ args0 -> args0 }))
            .requestsMem(requestsMem?.applyValue({ args0 -> args0 }))
            .webContainer(webContainer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sApplicationArgs].
 */
@PulumiTagMarker
public class K8sApplicationArgsBuilder internal constructor() {
    private var applicationDescriotion: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var command: Output<String>? = null

    private var commandArgs: Output<List<String>>? = null

    private var edasContainerVersion: Output<String>? = null

    private var envs: Output<Map<String, String>>? = null

    private var imageUrl: Output<String>? = null

    private var internetSlbId: Output<String>? = null

    private var internetSlbPort: Output<Int>? = null

    private var internetSlbProtocol: Output<String>? = null

    private var internetTargetPort: Output<Int>? = null

    private var jdk: Output<String>? = null

    private var limitMCpu: Output<Int>? = null

    private var limitMem: Output<Int>? = null

    private var liveness: Output<String>? = null

    private var localVolume: Output<String>? = null

    private var logicalRegionId: Output<String>? = null

    private var mountDescs: Output<String>? = null

    private var namespace: Output<String>? = null

    private var nasId: Output<String>? = null

    private var packageType: Output<String>? = null

    private var packageUrl: Output<String>? = null

    private var packageVersion: Output<String>? = null

    private var postStart: Output<String>? = null

    private var preStop: Output<String>? = null

    private var readiness: Output<String>? = null

    private var replicas: Output<Int>? = null

    private var requestsMCpu: Output<Int>? = null

    private var requestsMem: Output<Int>? = null

    private var webContainer: Output<String>? = null

    /**
     * @param value The description of the application
     */
    @JvmName("xyvxilgpyohhxumg")
    public suspend fun applicationDescriotion(`value`: Output<String>) {
        this.applicationDescriotion = value
    }

    /**
     * @param value The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
     */
    @JvmName("jegmgbmafyydqrjf")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
     */
    @JvmName("xeryvrabfnvtgffa")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The set command, if set, will replace the startup command in the mirror when the mirror is started.
     */
    @JvmName("yhqiaesqdfsyyact")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
     */
    @JvmName("pamcfbsgrxoipdoi")
    public suspend fun commandArgs(`value`: Output<List<String>>) {
        this.commandArgs = value
    }

    @JvmName("avwmcfmnipltvwiu")
    public suspend fun commandArgs(vararg values: Output<String>) {
        this.commandArgs = Output.all(values.asList())
    }

    /**
     * @param values Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
     */
    @JvmName("dlhlmohdgqymkopg")
    public suspend fun commandArgs(values: List<Output<String>>) {
        this.commandArgs = Output.all(values)
    }

    /**
     * @param value EDAS-Container version that the deployed package depends on. Image does not support this parameter.
     */
    @JvmName("kwtypkvygemddrhq")
    public suspend fun edasContainerVersion(`value`: Output<String>) {
        this.edasContainerVersion = value
    }

    /**
     * @param value Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
     */
    @JvmName("bspxfffjaltoipcd")
    public suspend fun envs(`value`: Output<Map<String, String>>) {
        this.envs = value
    }

    /**
     * @param value Mirror address. When the package_type is set to 'Image', this parameter item is required.
     */
    @JvmName("hptmqbygemsdekvk")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("ewwyinqqxmtfbrxp")
    public suspend fun internetSlbId(`value`: Output<String>) {
        this.internetSlbId = value
    }

    /**
     * @param value The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("rswjfmhtcmwqfcfs")
    public suspend fun internetSlbPort(`value`: Output<Int>) {
        this.internetSlbPort = value
    }

    /**
     * @param value The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("qmnimchjplbofbrn")
    public suspend fun internetSlbProtocol(`value`: Output<String>) {
        this.internetSlbProtocol = value
    }

    /**
     * @param value The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("uewjxmveoroycfov")
    public suspend fun internetTargetPort(`value`: Output<Int>) {
        this.internetTargetPort = value
    }

    /**
     * @param value The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
     */
    @JvmName("tnlmsxmejlyfyttc")
    public suspend fun jdk(`value`: Output<String>) {
        this.jdk = value
    }

    /**
     * @param value The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
     */
    @JvmName("uyundwjoeegatfbx")
    public suspend fun limitMCpu(`value`: Output<Int>) {
        this.limitMCpu = value
    }

    /**
     * @param value The memory limit of the application instance during application operation, unit: M.
     */
    @JvmName("uompcjkkisxhnxcy")
    public suspend fun limitMem(`value`: Output<Int>) {
        this.limitMem = value
    }

    /**
     * @param value Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
     */
    @JvmName("qrteycwsflfumamq")
    public suspend fun liveness(`value`: Output<String>) {
        this.liveness = value
    }

    /**
     * @param value The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
     */
    @JvmName("nnrjedwkxrawbgli")
    public suspend fun localVolume(`value`: Output<String>) {
        this.localVolume = value
    }

    /**
     * @param value The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
     */
    @JvmName("jqmtfjhyyiimxjri")
    public suspend fun logicalRegionId(`value`: Output<String>) {
        this.logicalRegionId = value
    }

    /**
     * @param value Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
     */
    @JvmName("jfkcrukuqvkoykoq")
    public suspend fun mountDescs(`value`: Output<String>) {
        this.mountDescs = value
    }

    /**
     * @param value The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
     */
    @JvmName("jqxgbfcrqwfurlit")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
     */
    @JvmName("mxdmkunwjtjggvso")
    public suspend fun nasId(`value`: Output<String>) {
        this.nasId = value
    }

    /**
     * @param value Application package type. Optional parameter values include: FatJar, WAR and Image.
     */
    @JvmName("bsyvvagtqajkpiae")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
     */
    @JvmName("plwvkgpnmujdsopb")
    public suspend fun packageUrl(`value`: Output<String>) {
        this.packageUrl = value
    }

    /**
     * @param value The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
     */
    @JvmName("ghhwwubyhabmpdfu")
    public suspend fun packageVersion(`value`: Output<String>) {
        this.packageVersion = value
    }

    /**
     * @param value Execute script after startup
     */
    @JvmName("mlaawfaifujhtirr")
    public suspend fun postStart(`value`: Output<String>) {
        this.postStart = value
    }

    /**
     * @param value Execute script before stopping
     */
    @JvmName("vqyfxouovpxtlkpe")
    public suspend fun preStop(`value`: Output<String>) {
        this.preStop = value
    }

    /**
     * @param value Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
     */
    @JvmName("xodgjjvnshjrtklu")
    public suspend fun readiness(`value`: Output<String>) {
        this.readiness = value
    }

    /**
     * @param value Number of application instances.
     */
    @JvmName("htegjbaybyitrvcf")
    public suspend fun replicas(`value`: Output<Int>) {
        this.replicas = value
    }

    /**
     * @param value When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
     */
    @JvmName("thqfiuueyhbjblqe")
    public suspend fun requestsMCpu(`value`: Output<Int>) {
        this.requestsMCpu = value
    }

    /**
     * @param value When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
     */
    @JvmName("elwiasycvgqmiynm")
    public suspend fun requestsMem(`value`: Output<Int>) {
        this.requestsMem = value
    }

    /**
     * @param value The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
     */
    @JvmName("hcxwwtyfcgnmeugl")
    public suspend fun webContainer(`value`: Output<String>) {
        this.webContainer = value
    }

    /**
     * @param value The description of the application
     */
    @JvmName("opqstrwkkissgxey")
    public suspend fun applicationDescriotion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationDescriotion = mapped
    }

    /**
     * @param value The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
     */
    @JvmName("asoynupdgsqovqri")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
     */
    @JvmName("owcumhwkknllrwdh")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The set command, if set, will replace the startup command in the mirror when the mirror is started.
     */
    @JvmName("veoocudpjqpufhxi")
    public suspend fun command(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
     */
    @JvmName("gpjimmyhunetjupg")
    public suspend fun commandArgs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandArgs = mapped
    }

    /**
     * @param values Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
     */
    @JvmName("yihiiwdrnbtptyfd")
    public suspend fun commandArgs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandArgs = mapped
    }

    /**
     * @param value EDAS-Container version that the deployed package depends on. Image does not support this parameter.
     */
    @JvmName("jytsyvyevxqouloh")
    public suspend fun edasContainerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edasContainerVersion = mapped
    }

    /**
     * @param value Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
     */
    @JvmName("icdqxykppgktxiud")
    public suspend fun envs(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envs = mapped
    }

    /**
     * @param values Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
     */
    @JvmName("cglyhweqkduordmv")
    public fun envs(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envs = mapped
    }

    /**
     * @param value Mirror address. When the package_type is set to 'Image', this parameter item is required.
     */
    @JvmName("kymdpfdupjdxxvrf")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("fxestotbeqopugua")
    public suspend fun internetSlbId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetSlbId = mapped
    }

    /**
     * @param value The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("bhbfrwkewcuyhhjf")
    public suspend fun internetSlbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetSlbPort = mapped
    }

    /**
     * @param value The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("cimaqyeurdujnxmi")
    public suspend fun internetSlbProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetSlbProtocol = mapped
    }

    /**
     * @param value The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
     * It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
     */
    @Deprecated(
        message = """
  Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment'
      replaces it
  """,
    )
    @JvmName("bfhkwvinnugsmqwa")
    public suspend fun internetTargetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetTargetPort = mapped
    }

    /**
     * @param value The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
     */
    @JvmName("dtpcnxsymtovmqra")
    public suspend fun jdk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jdk = mapped
    }

    /**
     * @param value The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
     */
    @JvmName("jswsbnaarlrojmof")
    public suspend fun limitMCpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitMCpu = mapped
    }

    /**
     * @param value The memory limit of the application instance during application operation, unit: M.
     */
    @JvmName("nnrqyuawroudorby")
    public suspend fun limitMem(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitMem = mapped
    }

    /**
     * @param value Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
     */
    @JvmName("aoooqbiecwculaus")
    public suspend fun liveness(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveness = mapped
    }

    /**
     * @param value The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
     */
    @JvmName("yaoqjmfmwcqjlteu")
    public suspend fun localVolume(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localVolume = mapped
    }

    /**
     * @param value The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
     */
    @JvmName("bbduvskyvadlknby")
    public suspend fun logicalRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalRegionId = mapped
    }

    /**
     * @param value Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
     */
    @JvmName("aqvoqpbxkcrvrulf")
    public suspend fun mountDescs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountDescs = mapped
    }

    /**
     * @param value The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
     */
    @JvmName("xbppvmhjiljcfqbk")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
     */
    @JvmName("oftxtoagffadmfvn")
    public suspend fun nasId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasId = mapped
    }

    /**
     * @param value Application package type. Optional parameter values include: FatJar, WAR and Image.
     */
    @JvmName("eokflrvvveplmhck")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
     */
    @JvmName("chhtblefiwqgnixj")
    public suspend fun packageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageUrl = mapped
    }

    /**
     * @param value The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
     */
    @JvmName("okkeipsolmntfwpx")
    public suspend fun packageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageVersion = mapped
    }

    /**
     * @param value Execute script after startup
     */
    @JvmName("mwsanapivpvxgftn")
    public suspend fun postStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postStart = mapped
    }

    /**
     * @param value Execute script before stopping
     */
    @JvmName("xsxsapdslduqelka")
    public suspend fun preStop(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preStop = mapped
    }

    /**
     * @param value Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
     */
    @JvmName("tbfvmatcdqoesyxt")
    public suspend fun readiness(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readiness = mapped
    }

    /**
     * @param value Number of application instances.
     */
    @JvmName("jpxsbwvfktdjqxym")
    public suspend fun replicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param value When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
     */
    @JvmName("tkptiytkkdydaddq")
    public suspend fun requestsMCpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestsMCpu = mapped
    }

    /**
     * @param value When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
     */
    @JvmName("deecuvabtjyruokf")
    public suspend fun requestsMem(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestsMem = mapped
    }

    /**
     * @param value The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
     */
    @JvmName("oyjdmicolpxurdrx")
    public suspend fun webContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webContainer = mapped
    }

    internal fun build(): K8sApplicationArgs = K8sApplicationArgs(
        applicationDescriotion = applicationDescriotion,
        applicationName = applicationName,
        clusterId = clusterId,
        command = command,
        commandArgs = commandArgs,
        edasContainerVersion = edasContainerVersion,
        envs = envs,
        imageUrl = imageUrl,
        internetSlbId = internetSlbId,
        internetSlbPort = internetSlbPort,
        internetSlbProtocol = internetSlbProtocol,
        internetTargetPort = internetTargetPort,
        jdk = jdk,
        limitMCpu = limitMCpu,
        limitMem = limitMem,
        liveness = liveness,
        localVolume = localVolume,
        logicalRegionId = logicalRegionId,
        mountDescs = mountDescs,
        namespace = namespace,
        nasId = nasId,
        packageType = packageType,
        packageUrl = packageUrl,
        packageVersion = packageVersion,
        postStart = postStart,
        preStop = preStop,
        readiness = readiness,
        replicas = replicas,
        requestsMCpu = requestsMCpu,
        requestsMem = requestsMem,
        webContainer = webContainer,
    )
}
