@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [K8sCluster].
 */
@PulumiTagMarker
public class K8sClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: K8sClusterArgs = K8sClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend K8sClusterArgsBuilder.() -> Unit) {
        val builder = K8sClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): K8sCluster {
        val builtJavaResource = com.pulumi.alicloud.edas.K8sCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return K8sCluster(builtJavaResource)
    }
}

/**
 * Provides an EDAS K8s cluster resource. For information about EDAS K8s Cluster and how to use it, see[What is EDAS K8s Cluster](https://www.alibabacloud.com/help/en/doc-detail/85108.htm).
 * > **NOTE:** Available since v1.93.0.
 * ## Import
 * EDAS cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sCluster:K8sCluster cluster cluster_id
 * ```
 */
public class K8sCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.edas.K8sCluster,
) : KotlinCustomResource(javaResource, K8sClusterMapper) {
    /**
     * The import status of cluster:
     * `1`: success.
     * `2`: failed.
     * `3`: importing.
     * `4`: deleted.
     */
    public val clusterImportStatus: Output<Int>
        get() = javaResource.clusterImportStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the cluster that you want to create.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * The type of the cluster that you want to create. Valid values only: 5: K8s cluster.
     */
    public val clusterType: Output<Int>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * The ID of the alicloud container service kubernetes cluster that you want to import.
     */
    public val csClusterId: Output<String>
        get() = javaResource.csClusterId().applyValue({ args0 -> args0 })

    /**
     * The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
     */
    public val namespaceId: Output<String>?
        get() = javaResource.namespaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
     */
    public val networkMode: Output<Int>
        get() = javaResource.networkMode().applyValue({ args0 -> args0 })

    /**
     * The ID of the Virtual Private Cloud (VPC) for the cluster.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object K8sClusterMapper : ResourceMapper<K8sCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.edas.K8sCluster::class == javaResource::class

    override fun map(javaResource: Resource): K8sCluster = K8sCluster(
        javaResource as
            com.pulumi.alicloud.edas.K8sCluster,
    )
}

/**
 * @see [K8sCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [K8sCluster].
 */
public suspend fun k8sCluster(name: String, block: suspend K8sClusterResourceBuilder.() -> Unit): K8sCluster {
    val builder = K8sClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [K8sCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun k8sCluster(name: String): K8sCluster {
    val builder = K8sClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
