@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.K8sClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an EDAS K8s cluster resource. For information about EDAS K8s Cluster and how to use it, see[What is EDAS K8s Cluster](https://www.alibabacloud.com/help/en/doc-detail/85108.htm).
 * > **NOTE:** Available since v1.93.0.
 * ## Import
 * EDAS cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sCluster:K8sCluster cluster cluster_id
 * ```
 * @property csClusterId The ID of the alicloud container service kubernetes cluster that you want to import.
 * @property namespaceId The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
 */
public data class K8sClusterArgs(
    public val csClusterId: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.K8sClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.K8sClusterArgs =
        com.pulumi.alicloud.edas.K8sClusterArgs.builder()
            .csClusterId(csClusterId?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sClusterArgs].
 */
@PulumiTagMarker
public class K8sClusterArgsBuilder internal constructor() {
    private var csClusterId: Output<String>? = null

    private var namespaceId: Output<String>? = null

    /**
     * @param value The ID of the alicloud container service kubernetes cluster that you want to import.
     */
    @JvmName("dwrawsfmbdednsnm")
    public suspend fun csClusterId(`value`: Output<String>) {
        this.csClusterId = value
    }

    /**
     * @param value The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
     */
    @JvmName("hlrceblfnojnijjo")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The ID of the alicloud container service kubernetes cluster that you want to import.
     */
    @JvmName("vrqkupefdhaomqba")
    public suspend fun csClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csClusterId = mapped
    }

    /**
     * @param value The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
     */
    @JvmName("fbkjahegpnngbltq")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    internal fun build(): K8sClusterArgs = K8sClusterArgs(
        csClusterId = csClusterId,
        namespaceId = namespaceId,
    )
}
