@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.kotlin.outputs.K8sSlbAttachmentSlbConfig
import com.pulumi.alicloud.edas.kotlin.outputs.K8sSlbAttachmentSlbConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [K8sSlbAttachment].
 */
@PulumiTagMarker
public class K8sSlbAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: K8sSlbAttachmentArgs = K8sSlbAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend K8sSlbAttachmentArgsBuilder.() -> Unit) {
        val builder = K8sSlbAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): K8sSlbAttachment {
        val builtJavaResource = com.pulumi.alicloud.edas.K8sSlbAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return K8sSlbAttachment(builtJavaResource)
    }
}

/**
 * Binds SLBs to an EDAS k8s application.
 * For information about EDAS k8s slb attachment and how to use it, see [What is k8s slb attachment](https://www.alibabacloud.com/help/en/enterprise-distributed-application-service/latest/bindk8sslb).
 * > **NOTE:** Available since v1.194.0.
 * ## Import
 * Slb information of EDAS k8s application can be imported using the ID of an EDAS k8s application. e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sSlbAttachment:K8sSlbAttachment example <EDAS k8s app id>
 * ```
 */
public class K8sSlbAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.edas.K8sSlbAttachment,
) : KotlinCustomResource(javaResource, K8sSlbAttachmentMapper) {
    /**
     * The ID of the EDAS k8s application to which you want to bind SLB instances.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    public val slbConfigs: Output<List<K8sSlbAttachmentSlbConfig>>
        get() = javaResource.slbConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object K8sSlbAttachmentMapper : ResourceMapper<K8sSlbAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.edas.K8sSlbAttachment::class == javaResource::class

    override fun map(javaResource: Resource): K8sSlbAttachment = K8sSlbAttachment(
        javaResource as
            com.pulumi.alicloud.edas.K8sSlbAttachment,
    )
}

/**
 * @see [K8sSlbAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [K8sSlbAttachment].
 */
public suspend fun k8sSlbAttachment(
    name: String,
    block: suspend K8sSlbAttachmentResourceBuilder.() -> Unit,
): K8sSlbAttachment {
    val builder = K8sSlbAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [K8sSlbAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun k8sSlbAttachment(name: String): K8sSlbAttachment {
    val builder = K8sSlbAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
