@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.alicloud.edas.K8sSlbAttachmentArgs.builder
import com.pulumi.alicloud.edas.kotlin.inputs.K8sSlbAttachmentSlbConfigArgs
import com.pulumi.alicloud.edas.kotlin.inputs.K8sSlbAttachmentSlbConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Binds SLBs to an EDAS k8s application.
 * For information about EDAS k8s slb attachment and how to use it, see [What is k8s slb attachment](https://www.alibabacloud.com/help/en/enterprise-distributed-application-service/latest/bindk8sslb).
 * > **NOTE:** Available since v1.194.0.
 * ## Import
 * Slb information of EDAS k8s application can be imported using the ID of an EDAS k8s application. e.g.
 * ```sh
 * $ pulumi import alicloud:edas/k8sSlbAttachment:K8sSlbAttachment example <EDAS k8s app id>
 * ```
 * @property appId The ID of the EDAS k8s application to which you want to bind SLB instances.
 * @property slbConfigs The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
 */
public data class K8sSlbAttachmentArgs(
    public val appId: Output<String>? = null,
    public val slbConfigs: Output<List<K8sSlbAttachmentSlbConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.K8sSlbAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.K8sSlbAttachmentArgs =
        com.pulumi.alicloud.edas.K8sSlbAttachmentArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .slbConfigs(
                slbConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [K8sSlbAttachmentArgs].
 */
@PulumiTagMarker
public class K8sSlbAttachmentArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var slbConfigs: Output<List<K8sSlbAttachmentSlbConfigArgs>>? = null

    /**
     * @param value The ID of the EDAS k8s application to which you want to bind SLB instances.
     */
    @JvmName("lgivnayjnrwdamem")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("qiyhhptmlqfttceb")
    public suspend fun slbConfigs(`value`: Output<List<K8sSlbAttachmentSlbConfigArgs>>) {
        this.slbConfigs = value
    }

    @JvmName("woslkjnscqmvgqio")
    public suspend fun slbConfigs(vararg values: Output<K8sSlbAttachmentSlbConfigArgs>) {
        this.slbConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("adefsmvnxyqikwhb")
    public suspend fun slbConfigs(values: List<Output<K8sSlbAttachmentSlbConfigArgs>>) {
        this.slbConfigs = Output.all(values)
    }

    /**
     * @param value The ID of the EDAS k8s application to which you want to bind SLB instances.
     */
    @JvmName("awvwtybckrybhefv")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("jrbmoejmpbbcfwur")
    public suspend fun slbConfigs(`value`: List<K8sSlbAttachmentSlbConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbConfigs = mapped
    }

    /**
     * @param argument The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("lgdafaembvfowxxo")
    public suspend fun slbConfigs(argument: List<suspend K8sSlbAttachmentSlbConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            K8sSlbAttachmentSlbConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slbConfigs = mapped
    }

    /**
     * @param argument The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("nqyigweaoiullnpc")
    public suspend fun slbConfigs(vararg argument: suspend K8sSlbAttachmentSlbConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            K8sSlbAttachmentSlbConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slbConfigs = mapped
    }

    /**
     * @param argument The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("tnaubmrvyiqvqrhr")
    public suspend fun slbConfigs(argument: suspend K8sSlbAttachmentSlbConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            K8sSlbAttachmentSlbConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.slbConfigs = mapped
    }

    /**
     * @param values The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
     */
    @JvmName("iwohyyvxipyuwjam")
    public suspend fun slbConfigs(vararg values: K8sSlbAttachmentSlbConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slbConfigs = mapped
    }

    internal fun build(): K8sSlbAttachmentArgs = K8sSlbAttachmentArgs(
        appId = appId,
        slbConfigs = slbConfigs,
    )
}
