@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource = com.pulumi.alicloud.edas.Namespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Namespace(builtJavaResource)
    }
}

/**
 * Provides a EDAS Namespace resource.
 * For information about EDAS Namespace and how to use it, see [What is Namespace](https://www.alibabacloud.com/help/en/enterprise-distributed-application-service/latest/insertorupdateregion).
 * > **NOTE:** Available since v1.173.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "tfexample";
 * const _default = new alicloud.edas.Namespace("default", {
 *     debugEnable: false,
 *     description: name,
 *     namespaceLogicalId: `${region}:${name}`,
 *     namespaceName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.edas.Namespace("default",
 *     debug_enable=False,
 *     description=name,
 *     namespace_logical_id=f"{region}:{name}",
 *     namespace_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = new AliCloud.Edas.Namespace("default", new()
 *     {
 *         DebugEnable = false,
 *         Description = name,
 *         NamespaceLogicalId = $"{region}:{name}",
 *         NamespaceName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/edas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := edas.NewNamespace(ctx, "default", &edas.NamespaceArgs{
 * 			DebugEnable:        pulumi.Bool(false),
 * 			Description:        pulumi.String(name),
 * 			NamespaceLogicalId: pulumi.Sprintf("%v:%v", region, name),
 * 			NamespaceName:      pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.edas.Namespace;
 * import com.pulumi.alicloud.edas.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("tfexample");
 *         var default_ = new Namespace("default", NamespaceArgs.builder()
 *             .debugEnable(false)
 *             .description(name)
 *             .namespaceLogicalId(String.format("%s:%s", region,name))
 *             .namespaceName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   default:
 *     type: alicloud:edas:Namespace
 *     properties:
 *       debugEnable: false
 *       description: ${name}
 *       namespaceLogicalId: ${region}:${name}
 *       namespaceName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EDAS Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:edas/namespace:Namespace example <id>
 * ```
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.alicloud.edas.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    /**
     * Specifies whether to enable remote debugging.
     */
    public val debugEnable: Output<Boolean>
        get() = javaResource.debugEnable().applyValue({ args0 -> args0 })

    /**
     * The description of the namespace, The description can be up to `128` characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the namespace.
     * - The ID of a custom namespace is in the `region ID:namespace identifier` format. An example is `cn-beijing:tdy218`.
     * - The ID of the default namespace is in the `region ID` format. An example is cn-beijing.
     */
    public val namespaceLogicalId: Output<String>
        get() = javaResource.namespaceLogicalId().applyValue({ args0 -> args0 })

    /**
     * The name of the namespace, The name can be up to `63` characters in length.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.edas.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.alicloud.edas.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
