@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.GetApplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplications.
 * @property ids An ids string to filter results by the application id.
 * @property nameRegex A regex string to filter results by the application name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetApplicationsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.inputs.GetApplicationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.GetApplicationsPlainArgs =
        com.pulumi.alicloud.edas.inputs.GetApplicationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationsPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value An ids string to filter results by the application id.
     */
    @JvmName("mfthtwyhgexiyigp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values An ids string to filter results by the application id.
     */
    @JvmName("jtdvjcuqdhsicydb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by the application name.
     */
    @JvmName("loovwrxhuunfiyfm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xjnfqjeuntqkttek")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetApplicationsPlainArgs = GetApplicationsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
