@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property ids An ids string to filter results by the cluster id.
 * @property logicalRegionId ID of the namespace in EDAS.
 * @property nameRegex A regex string to filter results by the cluster name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetClustersPlainArgs(
    public val ids: List<String>? = null,
    public val logicalRegionId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.GetClustersPlainArgs =
        com.pulumi.alicloud.edas.inputs.GetClustersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .logicalRegionId(logicalRegionId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var logicalRegionId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value An ids string to filter results by the cluster id.
     */
    @JvmName("mxcrrsboaebkikri")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values An ids string to filter results by the cluster id.
     */
    @JvmName("tbnjmnjjsrofoviq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the namespace in EDAS.
     */
    @JvmName("tbpawdichalspebv")
    public suspend fun logicalRegionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.logicalRegionId = mapped
    }

    /**
     * @param value A regex string to filter results by the cluster name.
     */
    @JvmName("wvvltlondjypdsbh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qjvaaottchonxpgt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        ids = ids,
        logicalRegionId = logicalRegionId ?: throw PulumiNullFieldException("logicalRegionId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
