@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.GetDeployGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDeployGroups.
 * @property appId ID of the EDAS application.
 * @property nameRegex A regex string to filter results by the deploy group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDeployGroupsPlainArgs(
    public val appId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.edas.inputs.GetDeployGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.GetDeployGroupsPlainArgs =
        com.pulumi.alicloud.edas.inputs.GetDeployGroupsPlainArgs.builder()
            .appId(appId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeployGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetDeployGroupsPlainArgsBuilder internal constructor() {
    private var appId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value ID of the EDAS application.
     */
    @JvmName("gulhuvexpocnshkq")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appId = mapped
    }

    /**
     * @param value A regex string to filter results by the deploy group name.
     */
    @JvmName("kbdxsypeflhxtemc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("eotwbvmkxsmkkyiv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDeployGroupsPlainArgs = GetDeployGroupsPlainArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
