@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of this SLB configuration, empty for auto-generated by EDAS server.
 * @property portMappings The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
 * @property scheduler The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
 * @property slbId The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
 * @property specification The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
 * @property type The type of SLB instance, values can be 'internet' or 'intranet'.
 */
public data class K8sSlbAttachmentSlbConfigArgs(
    public val name: Output<String>? = null,
    public val portMappings: Output<List<K8sSlbAttachmentSlbConfigPortMappingArgs>>,
    public val scheduler: Output<String>,
    public val slbId: Output<String>? = null,
    public val specification: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigArgs =
        com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .portMappings(
                portMappings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheduler(scheduler.applyValue({ args0 -> args0 }))
            .slbId(slbId?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sSlbAttachmentSlbConfigArgs].
 */
@PulumiTagMarker
public class K8sSlbAttachmentSlbConfigArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var portMappings: Output<List<K8sSlbAttachmentSlbConfigPortMappingArgs>>? = null

    private var scheduler: Output<String>? = null

    private var slbId: Output<String>? = null

    private var specification: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of this SLB configuration, empty for auto-generated by EDAS server.
     */
    @JvmName("ajfhuxilxoqfyiih")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("vuadpixqvnygeyeb")
    public suspend fun portMappings(`value`: Output<List<K8sSlbAttachmentSlbConfigPortMappingArgs>>) {
        this.portMappings = value
    }

    @JvmName("wipncksomysirqvs")
    public suspend fun portMappings(vararg values: Output<K8sSlbAttachmentSlbConfigPortMappingArgs>) {
        this.portMappings = Output.all(values.asList())
    }

    /**
     * @param values The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("oxbegrxiqpfxhngy")
    public suspend fun portMappings(values: List<Output<K8sSlbAttachmentSlbConfigPortMappingArgs>>) {
        this.portMappings = Output.all(values)
    }

    /**
     * @param value The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
     */
    @JvmName("wpuvpdydbcxhfbhd")
    public suspend fun scheduler(`value`: Output<String>) {
        this.scheduler = value
    }

    /**
     * @param value The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
     */
    @JvmName("kudectxuoitudidj")
    public suspend fun slbId(`value`: Output<String>) {
        this.slbId = value
    }

    /**
     * @param value The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
     */
    @JvmName("oupucecbuabnabfp")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The type of SLB instance, values can be 'internet' or 'intranet'.
     */
    @JvmName("lkfmvrhoqdjhfxya")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of this SLB configuration, empty for auto-generated by EDAS server.
     */
    @JvmName("msnjpgpjbcqsgvgq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("nxhngixwnxixtlwx")
    public suspend fun portMappings(`value`: List<K8sSlbAttachmentSlbConfigPortMappingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portMappings = mapped
    }

    /**
     * @param argument The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("vukidtruicsdmnac")
    public suspend fun portMappings(argument: List<suspend K8sSlbAttachmentSlbConfigPortMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            K8sSlbAttachmentSlbConfigPortMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portMappings = mapped
    }

    /**
     * @param argument The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("ysgkotgqxbvlbggk")
    public suspend fun portMappings(vararg argument: suspend K8sSlbAttachmentSlbConfigPortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            K8sSlbAttachmentSlbConfigPortMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portMappings = mapped
    }

    /**
     * @param argument The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("dckayegbhuuhuqrx")
    public suspend fun portMappings(argument: suspend K8sSlbAttachmentSlbConfigPortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            K8sSlbAttachmentSlbConfigPortMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portMappings = mapped
    }

    /**
     * @param values The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
     */
    @JvmName("moylinujmiqnunpm")
    public suspend fun portMappings(vararg values: K8sSlbAttachmentSlbConfigPortMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portMappings = mapped
    }

    /**
     * @param value The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
     */
    @JvmName("onfqoeefbpdfhvnn")
    public suspend fun scheduler(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduler = mapped
    }

    /**
     * @param value The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
     */
    @JvmName("ejmubhixkfixnaaf")
    public suspend fun slbId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbId = mapped
    }

    /**
     * @param value The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
     */
    @JvmName("loyvrrehdkaxmmvg")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The type of SLB instance, values can be 'internet' or 'intranet'.
     */
    @JvmName("wcbdfnmjthatisup")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): K8sSlbAttachmentSlbConfigArgs = K8sSlbAttachmentSlbConfigArgs(
        name = name,
        portMappings = portMappings ?: throw PulumiNullFieldException("portMappings"),
        scheduler = scheduler ?: throw PulumiNullFieldException("scheduler"),
        slbId = slbId,
        specification = specification,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
