@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property certId The ID of your tls certification, this is used for 'HTTPS' protocol only.
 * @property loadbalancerProtocol The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
 * @property servicePort The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
 */
public data class K8sSlbAttachmentSlbConfigPortMappingArgs(
    public val certId: Output<String>? = null,
    public val loadbalancerProtocol: Output<String>,
    public val servicePort: Output<K8sSlbAttachmentSlbConfigPortMappingServicePortArgs>,
) : ConvertibleToJava<com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingArgs =
        com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingArgs.builder()
            .certId(certId?.applyValue({ args0 -> args0 }))
            .loadbalancerProtocol(loadbalancerProtocol.applyValue({ args0 -> args0 }))
            .servicePort(servicePort.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [K8sSlbAttachmentSlbConfigPortMappingArgs].
 */
@PulumiTagMarker
public class K8sSlbAttachmentSlbConfigPortMappingArgsBuilder internal constructor() {
    private var certId: Output<String>? = null

    private var loadbalancerProtocol: Output<String>? = null

    private var servicePort: Output<K8sSlbAttachmentSlbConfigPortMappingServicePortArgs>? = null

    /**
     * @param value The ID of your tls certification, this is used for 'HTTPS' protocol only.
     */
    @JvmName("frsgcgrmpwpbxccx")
    public suspend fun certId(`value`: Output<String>) {
        this.certId = value
    }

    /**
     * @param value The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
     */
    @JvmName("mnbmiobviyqtwsnq")
    public suspend fun loadbalancerProtocol(`value`: Output<String>) {
        this.loadbalancerProtocol = value
    }

    /**
     * @param value The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
     */
    @JvmName("ygooavrbcxsspmrw")
    public suspend fun servicePort(`value`: Output<K8sSlbAttachmentSlbConfigPortMappingServicePortArgs>) {
        this.servicePort = value
    }

    /**
     * @param value The ID of your tls certification, this is used for 'HTTPS' protocol only.
     */
    @JvmName("xjpofvnvdqsmurso")
    public suspend fun certId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certId = mapped
    }

    /**
     * @param value The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
     */
    @JvmName("dnodnhmmfdcyhtgl")
    public suspend fun loadbalancerProtocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadbalancerProtocol = mapped
    }

    /**
     * @param value The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
     */
    @JvmName("pcbdcauqsduqvvuv")
    public suspend fun servicePort(`value`: K8sSlbAttachmentSlbConfigPortMappingServicePortArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePort = mapped
    }

    /**
     * @param argument The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
     */
    @JvmName("ckjtdtgewagdqlre")
    public suspend fun servicePort(argument: suspend K8sSlbAttachmentSlbConfigPortMappingServicePortArgsBuilder.() -> Unit) {
        val toBeMapped = K8sSlbAttachmentSlbConfigPortMappingServicePortArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.servicePort = mapped
    }

    internal fun build(): K8sSlbAttachmentSlbConfigPortMappingArgs =
        K8sSlbAttachmentSlbConfigPortMappingArgs(
            certId = certId,
            loadbalancerProtocol = loadbalancerProtocol ?: throw
                PulumiNullFieldException("loadbalancerProtocol"),
            servicePort = servicePort ?: throw PulumiNullFieldException("servicePort"),
        )
}
