@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.inputs

import com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingServicePortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The port of k8s service, values should be within range [1, 65535].
 * @property protocol The protocol of k8s service, values can be 'TCP' or 'UDP'.
 * @property targetPort The port of k8s pod, values should be within range [1, 65535].
 */
public data class K8sSlbAttachmentSlbConfigPortMappingServicePortArgs(
    public val port: Output<Int>,
    public val protocol: Output<String>,
    public val targetPort: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingServicePortArgs> {
    override fun toJava(): com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingServicePortArgs =
        com.pulumi.alicloud.edas.inputs.K8sSlbAttachmentSlbConfigPortMappingServicePortArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .targetPort(targetPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sSlbAttachmentSlbConfigPortMappingServicePortArgs].
 */
@PulumiTagMarker
public class K8sSlbAttachmentSlbConfigPortMappingServicePortArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var targetPort: Output<Int>? = null

    /**
     * @param value The port of k8s service, values should be within range [1, 65535].
     */
    @JvmName("untmhyyriarifjyp")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol of k8s service, values can be 'TCP' or 'UDP'.
     */
    @JvmName("cvcxghececxcaeiq")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The port of k8s pod, values should be within range [1, 65535].
     */
    @JvmName("mbpmymiprwlbnskw")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value The port of k8s service, values should be within range [1, 65535].
     */
    @JvmName("wdhxiggxguecvviy")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol of k8s service, values can be 'TCP' or 'UDP'.
     */
    @JvmName("viiakudgbufkfapp")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The port of k8s pod, values should be within range [1, 65535].
     */
    @JvmName("ewuwipigtyuijhkq")
    public suspend fun targetPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    internal fun build(): K8sSlbAttachmentSlbConfigPortMappingServicePortArgs =
        K8sSlbAttachmentSlbConfigPortMappingServicePortArgs(
            port = port ?: throw PulumiNullFieldException("port"),
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            targetPort = targetPort ?: throw PulumiNullFieldException("targetPort"),
        )
}
