@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appId The ID of the application that you want to deploy.
 * @property appName The name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
 * @property applicationType The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
 * @property buildPackageId The package ID of Enterprise Distributed Application Service (EDAS) Container.
 * @property clusterId The ID of the cluster that you want to create the application.
 * @property clusterType The type of the cluster that you want to create. Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
 * @property regionId The ID of the namespace the application belongs to.
 */
public data class GetApplicationsApplication(
    public val appId: String,
    public val appName: String,
    public val applicationType: String,
    public val buildPackageId: Int,
    public val clusterId: String,
    public val clusterType: Int,
    public val regionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetApplicationsApplication): GetApplicationsApplication = GetApplicationsApplication(
            appId = javaType.appId(),
            appName = javaType.appName(),
            applicationType = javaType.applicationType(),
            buildPackageId = javaType.buildPackageId(),
            clusterId = javaType.clusterId(),
            clusterType = javaType.clusterType(),
            regionId = javaType.regionId(),
        )
    }
}
