@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplications.
 * @property applications A list of applications.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of application IDs.
 * @property nameRegex
 * @property names A list of applications names.
 * @property outputFile
 */
public data class GetApplicationsResult(
    public val applications: List<GetApplicationsApplication>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetApplicationsResult): GetApplicationsResult = GetApplicationsResult(
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.edas.kotlin.outputs.GetApplicationsApplication.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
