@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the cluster that you want to create the application.
 * @property clusterName The name of the cluster.
 * @property clusterType The type of the cluster, Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
 * @property cpu The total number of CPUs in the cluster.
 * @property cpuUsed The number of used CPUs in the cluster.
 * @property createTime Cluster's creation time.
 * @property mem The total amount of memory in the cluser. Unit: MB.
 * @property memUsed The amount of used memory in the cluser. Unit: MB.
 * @property networkMode The network type of the cluster. Valid values: 1: classic network. 2: VPC.
 * @property nodeNum The number of the Elastic Compute Service (ECS) instances that are deployed to the cluster.
 * @property regionId The ID of the namespace the application belongs to.
 * @property updateTime The time when the cluster was last updated.
 * @property vpcId The ID of the Virtual Private Cloud (VPC) for the cluster.
 */
public data class GetClustersCluster(
    public val clusterId: String,
    public val clusterName: String,
    public val clusterType: Int,
    public val cpu: Int,
    public val cpuUsed: Int,
    public val createTime: Int,
    public val mem: Int,
    public val memUsed: Int,
    public val networkMode: Int,
    public val nodeNum: Int,
    public val regionId: String,
    public val updateTime: Int,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            clusterType = javaType.clusterType(),
            cpu = javaType.cpu(),
            cpuUsed = javaType.cpuUsed(),
            createTime = javaType.createTime(),
            mem = javaType.mem(),
            memUsed = javaType.memUsed(),
            networkMode = javaType.networkMode(),
            nodeNum = javaType.nodeNum(),
            regionId = javaType.regionId(),
            updateTime = javaType.updateTime(),
            vpcId = javaType.vpcId(),
        )
    }
}
