@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appId ID of the EDAS application.
 * @property appVersionId The version of the deployment package for the application.
 * @property clusterId The ID of the cluster that you want to create the application.
 * @property createTime The time when the instance group was created.
 * @property groupId The ID of the instance group.
 * @property groupName The name of the instance group. The length cannot exceed 64 characters.
 * @property groupType The type of the instance group. Valid values: 0: Default group. 1: Phased release is disabled for traffic management. 2: Phased release is enabled for traffic management.
 * @property packageVersionId The version of the deployment package for the instance group that was created.
 * @property updateTime The time when the instance group was updated.
 */
public data class GetDeployGroupsGroup(
    public val appId: String,
    public val appVersionId: String,
    public val clusterId: String,
    public val createTime: Int,
    public val groupId: String,
    public val groupName: String,
    public val groupType: Int,
    public val packageVersionId: String,
    public val updateTime: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetDeployGroupsGroup): GetDeployGroupsGroup = GetDeployGroupsGroup(
            appId = javaType.appId(),
            appVersionId = javaType.appVersionId(),
            clusterId = javaType.clusterId(),
            createTime = javaType.createTime(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            groupType = javaType.groupType(),
            packageVersionId = javaType.packageVersionId(),
            updateTime = javaType.updateTime(),
        )
    }
}
